/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpHeaderField;
import com.intellij.ws.http.request.psi.HttpHeaderFieldValue;
import com.intellij.ws.http.request.psi.HttpRequestContentDescriptor;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.impl.HttpRequestCompositeElementImpl;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpRequestContentDescriptorImpl
extends HttpRequestCompositeElementImpl
implements HttpRequestContentDescriptor {
    public HttpRequestContentDescriptorImpl(@NotNull ASTNode node) {
        if (node == null) {
            HttpRequestContentDescriptorImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    public HttpHeaderField getHeaderField(@NotNull String fieldName) {
        if (fieldName == null) {
            HttpRequestContentDescriptorImpl.$$$reportNull$$$0(1);
        }
        return HttpRequestContentDescriptorImpl.getHeaderField(this.getHeaderFieldList(), fieldName);
    }

    @Nullable
    private static HttpHeaderField getHeaderField(@NotNull List<HttpHeaderField> headers, @NotNull String fieldName) {
        if (headers == null) {
            HttpRequestContentDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (fieldName == null) {
            HttpRequestContentDescriptorImpl.$$$reportNull$$$0(3);
        }
        return headers.stream().filter(field -> {
            if (fieldName == null) {
                HttpRequestContentDescriptorImpl.$$$reportNull$$$0(11);
            }
            return StringUtil.equalsIgnoreCase((CharSequence)field.getName(), (CharSequence)fieldName);
        }).filter(field -> field.getHeaderFieldValue() != null).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public ContentType getContentType(@NotNull HttpRequestVariableSubstitutor substitutor) {
        List fields;
        ContentType contentType;
        if (substitutor == null) {
            HttpRequestContentDescriptorImpl.$$$reportNull$$$0(4);
        }
        if ((contentType = this.parseContentType(fields = this.getHeaderFieldList(), substitutor)).getCharset() == null) {
            HttpHeaderField charset = HttpRequestContentDescriptorImpl.getHeaderField(fields, "Accept-Charset");
            contentType = contentType.withCharset(StringUtil.notNullize((String)(charset != null ? charset.getValue(substitutor) : null), (String)"UTF-8"));
        }
        ContentType contentType2 = contentType;
        if (contentType2 == null) {
            HttpRequestContentDescriptorImpl.$$$reportNull$$$0(5);
        }
        return contentType2;
    }

    @NotNull
    private ContentType parseContentType(@NotNull List<HttpHeaderField> fields, @NotNull HttpRequestVariableSubstitutor substitutor) {
        block8: {
            HttpHeaderField contentTypeField;
            if (fields == null) {
                HttpRequestContentDescriptorImpl.$$$reportNull$$$0(6);
            }
            if (substitutor == null) {
                HttpRequestContentDescriptorImpl.$$$reportNull$$$0(7);
            }
            if ((contentTypeField = HttpRequestContentDescriptorImpl.getHeaderField(fields, "Content-Type")) != null) {
                ContentType contentType;
                try {
                    contentType = ContentType.parse((String)StringUtil.notNullize((String)contentTypeField.getValue(substitutor), (String)"*/*"));
                }
                catch (Exception e) {
                    String mimeType = this.getMimeType();
                    if (!StringUtil.isNotEmpty((String)mimeType)) break block8;
                    ContentType contentType2 = ContentType.create((String)mimeType);
                    if (contentType2 == null) {
                        HttpRequestContentDescriptorImpl.$$$reportNull$$$0(9);
                    }
                    return contentType2;
                }
                if (contentType == null) {
                    HttpRequestContentDescriptorImpl.$$$reportNull$$$0(8);
                }
                return contentType;
            }
        }
        ContentType contentType = ContentType.parse((String)"*/*");
        if (contentType == null) {
            HttpRequestContentDescriptorImpl.$$$reportNull$$$0(10);
        }
        return contentType;
    }

    @Override
    @Nullable
    public String getMimeType() {
        HttpHeaderField contentTypeField = this.getHeaderField("Content-Type");
        if (contentTypeField != null) {
            String value;
            HttpHeaderFieldValue header = contentTypeField.getHeaderFieldValue();
            PsiElement contentType = header != null ? HttpRequestPsiUtils.getNextSiblingByType(header.getFirstChild(), HttpRequestElementTypes.FIELD_VALUE, false) : null;
            String string = value = contentType != null ? contentType.getText() : null;
            if (HttpRequestContentDescriptorImpl.isValidMimeType(value)) {
                return value;
            }
        }
        return null;
    }

    private static boolean isValidMimeType(@Nullable String value) {
        return StringUtil.isNotEmpty((String)value) && !StringUtil.containsAnyChar((String)value, (String)"\";,");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/psi/impl/HttpRequestContentDescriptorImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/psi/impl/HttpRequestContentDescriptorImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContentType";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseContentType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHeaderField$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

