/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class HttpSuffixInsertHandler
implements InsertHandler<LookupElement> {
    public static final HttpSuffixInsertHandler HEADER_OPTION = new HttpSuffixInsertHandler("=");
    public static final HttpSuffixInsertHandler SCHEME = new HttpSuffixInsertHandler("://");
    public static final HttpSuffixInsertHandler FIELD_SEPARATOR = new HttpSuffixInsertHandler(": ");
    private final String mySuffix;
    private final String myShortSuffix;

    public HttpSuffixInsertHandler(@NotNull String suffix) {
        if (suffix == null) {
            HttpSuffixInsertHandler.$$$reportNull$$$0(0);
        }
        this.mySuffix = suffix;
        this.myShortSuffix = suffix.trim();
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Project project = context.getProject();
        if (project != null) {
            Editor editor = context.getEditor();
            int offset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == offset || !this.isEqualsToSuffix(document, offset)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)this.mySuffix);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
            editor.getCaretModel().moveToOffset(offset + this.mySuffix.length());
        }
    }

    private boolean isEqualsToSuffix(@NotNull Document document, int offset) {
        if (document == null) {
            HttpSuffixInsertHandler.$$$reportNull$$$0(1);
        }
        int endOffset = offset + this.myShortSuffix.length() - 1;
        if (document.getTextLength() <= endOffset) {
            return false;
        }
        return StringUtil.equals((CharSequence)this.myShortSuffix, (CharSequence)document.getCharsSequence().subSequence(offset, endOffset + 1).toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/completion/HttpSuffixInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualsToSuffix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

