/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.ws.actions.CreateRestClientAction;
import com.intellij.ws.rest.client.RESTClient;
import java.io.IOException;

public class RunRequestAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && vFile != null) {
            RESTClient client = CreateRestClientAction.openRestClient(project);
            client.importRequest(vFile);
        }
    }

    public void update(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        e.getPresentation().setVisible(RunRequestAction.isSingleRestClientRequest(files));
    }

    private static boolean isSingleRestClientRequest(VirtualFile[] files) {
        if (files == null || files.length != 1) {
            return false;
        }
        VirtualFile file = files[0];
        if (file.getFileType() != StdFileTypes.XML) {
            return false;
        }
        try {
            XmlFileHeader header = NanoXmlUtil.parseHeaderWithException((VirtualFile)file);
            return "RestClientRequest".equals(header.getRootTagLocalName());
        }
        catch (IOException e) {
            return false;
        }
    }
}

