/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.facet.FacetType;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.MockJdkWrapper;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.builders.WebModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.WebModuleTestFixture;
import com.intellij.testFramework.fixtures.impl.JavaModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.WebModuleTestFixtureImpl;
import java.util.ArrayList;
import java.util.List;

public class WebModuleFixtureBuilderImpl
extends JavaModuleFixtureBuilderImpl<WebModuleTestFixture>
implements WebModuleFixtureBuilder {
    private final List<Pair<String, String>> myWebRoots = new ArrayList<Pair<String, String>>();
    private String myWebXml;

    public WebModuleFixtureBuilderImpl(TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(StdModuleTypes.JAVA, fixtureBuilder);
    }

    protected Module createModule() {
        Module module = super.createModule();
        FacetUtil.addFacet((Module)module, (FacetType)WebFacetType.getInstance());
        return module;
    }

    protected WebModuleTestFixture instantiateFixture() {
        return new WebModuleTestFixtureImpl((ModuleFixtureBuilderImpl)this);
    }

    @Override
    public WebModuleFixtureBuilder addWebRoot(String rootPath, String relativePath) {
        this.myWebRoots.add((Pair<String, String>)Pair.create((Object)rootPath, (Object)relativePath));
        return this;
    }

    @Override
    public WebModuleFixtureBuilder setWebXml(String path) {
        if (this.myWebXml != null) {
            throw new IllegalStateException("Web xml is already set up to: " + this.myWebXml);
        }
        this.myWebXml = path;
        return this;
    }

    protected void libraryCreated(Library library, Module module) {
        super.libraryCreated(library, module);
        WebFacet webFacet = WebFacet.getInstances(module).iterator().next();
        JavaeeArtifactUtil.getInstance().addLibraryToAllArtifactsContainingFacet(library, webFacet);
    }

    protected void initModule(Module module) {
        super.initModule(module);
        WebFacet webFacet = WebFacet.getInstances(module).iterator().next();
        if (this.myWebXml != null) {
            String[] descriptors = webFacet.getDescriptorsContainer().getConfiguration();
            descriptors.addConfigFile(DeploymentDescriptorsConstants.WEB_XML_META_DATA, "file://" + this.myWebXml);
        }
        for (String url : ModuleRootManager.getInstance((Module)module).getSourceRootUrls()) {
            webFacet.addWebSourceRoot(url);
        }
        for (Pair pair : this.myWebRoots) {
            String path = VfsUtilCore.pathToUrl((String)((String)pair.first));
            String relativePath = (String)pair.second;
            webFacet.addWebRoot(path, relativePath);
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        assert (sdk != null) : module;
        sdk = IdeaTestUtil.addWebJarsTo((Sdk)((MockJdkWrapper)sdk).getDelegate());
        ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        modifiableRootModel.setSdk(sdk);
        modifiableRootModel.commit();
    }
}

