/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.xml.web.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.javaee.model.enums.WebAppVersion;
import com.intellij.javaee.model.xml.web.FilterMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServletNameConverter
extends ResolvingConverter<CommonServlet> {
    @NotNull
    public Collection<? extends CommonServlet> getVariants(ConvertContext context) {
        WebModel webModel = ServletNameConverter.getModel(context);
        List<Object> list = webModel == null ? Collections.emptyList() : webModel.getServlets();
        if (list == null) {
            ServletNameConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    static WebModel getModel(ConvertContext context) {
        XmlFile file = context.getFile();
        WebFacet facet = WebUtil.getWebFacet((PsiElement)file);
        if (facet != null && !facet.getWebApps().isEmpty()) {
            return facet.getWebModel();
        }
        return WebUtil.getWebUtil().getLocalWebModel(file);
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            ServletNameConverter.$$$reportNull$$$0(1);
        }
        if (context.getInvocationElement().getParent() instanceof FilterMapping) {
            WebApp webApp = (WebApp)context.getInvocationElement().getParentOfType(WebApp.class, false);
            assert (webApp != null);
            WebAppVersion version = (WebAppVersion)((Object)webApp.getVersion().getValue());
            if (version != null && WebAppVersion.WebAppVersion_2_5.compareTo(version) <= 0) {
                Set<String> set = Collections.singleton("*");
                if (set == null) {
                    ServletNameConverter.$$$reportNull$$$0(2);
                }
                return set;
            }
        } else {
            Set<String> set = Collections.singleton("default");
            if (set == null) {
                ServletNameConverter.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ServletNameConverter.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    public CommonServlet fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        WebModel webModel = ServletNameConverter.getModel(context);
        return webModel != null ? webModel.findServlet(s) : null;
    }

    @Nullable
    public String toString(@Nullable CommonServlet servlet, ConvertContext context) {
        return servlet != null ? servlet.getServletName().getStringValue() : null;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{"Servlet", s});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/model/xml/web/converters/ServletNameConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/model/xml/web/converters/ServletNameConverter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

