/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.common.ejb;

import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.PersistenceType;
import org.jetbrains.annotations.NonNls;

public class EjbPsiMethodUtil {
    @NonNls
    public static final String CREATE_PREFIX = "create";

    public static String[] suggestImplNames(String methodName, EjbMethodRoleEnum type, EnterpriseBean ejb) {
        String[] implName = new String[]{null, null};
        switch (type) {
            case EJB_METHOD_ROLE_FINDER_DECL: {
                if (((EntityBean)ejb).getPersistenceType().getValue() != PersistenceType.BEAN) break;
                implName[0] = "ejb" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
                break;
            }
            case EJB_METHOD_ROLE_CREATE_DECL: {
                if (ejb instanceof SessionBean || ejb instanceof MessageDrivenBean) {
                    implName[0] = "ejbCreate" + methodName.substring(CREATE_PREFIX.length());
                    break;
                }
                if (!(ejb instanceof EntityBean)) break;
                implName[0] = "ejbCreate" + methodName.substring(CREATE_PREFIX.length());
                implName[1] = "ejbPostCreate" + methodName.substring(CREATE_PREFIX.length());
                break;
            }
            case EJB_METHOD_ROLE_CMP_GETTER_DECL: 
            case EJB_METHOD_ROLE_CMP_SETTER_DECL: {
                implName[0] = methodName;
                break;
            }
            case EJB_METHOD_ROLE_CMR_GETTER_DECL: 
            case EJB_METHOD_ROLE_CMR_SETTER_DECL: {
                implName[0] = methodName;
                break;
            }
            case EJB_METHOD_ROLE_BUSINESS_METHOD_DECL: {
                implName[0] = methodName;
                break;
            }
            case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_DECL: {
                implName[0] = "ejbHome" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
            }
        }
        return implName;
    }
}

