/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.J2EEBundle;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public enum DeploymentStatus {
    DEPLOYED(J2EEBundle.message("deployment.status.name.deployed", new Object[0]), J2EEBundle.message("deployment.status.description.deployed", new Object[0]), AllIcons.RunConfigurations.TestPassed),
    NOT_DEPLOYED(J2EEBundle.message("deployment.status.name.not.deployed", new Object[0]), J2EEBundle.message("deployment.status.description.not.deployed", new Object[0]), AllIcons.RunConfigurations.TestError),
    FAILED(J2EEBundle.message("deployment.status.name.failed", new Object[0]), J2EEBundle.message("deployment.status.description.failed", new Object[0]), AllIcons.RunConfigurations.TestFailed),
    DEACTIVATING(J2EEBundle.message("deployment.status.name.deactivating", new Object[0]), J2EEBundle.message("deployment.status.description.deactivating", new Object[0]), AllIcons.RunConfigurations.TestInProgress1),
    PREPARING(J2EEBundle.message("deployment.status.name.preparing", new Object[0]), J2EEBundle.message("deployment.status.description.preparing", new Object[0]), AllIcons.RunConfigurations.TestInProgress1),
    PREPARED(J2EEBundle.message("deployment.status.name.prepared", new Object[0]), J2EEBundle.message("deployment.status.description.prepared", new Object[0]), AllIcons.RunConfigurations.TestInProgress2),
    ACTIVATING(J2EEBundle.message("deployment.status.name.activating", new Object[0]), J2EEBundle.message("deployment.status.description.activating", new Object[0]), AllIcons.RunConfigurations.TestInProgress3),
    UNPREPARED(J2EEBundle.message("deployment.status.name.unprepared", new Object[0]), J2EEBundle.message("deployment.status.description.unprepared", new Object[0]), AllIcons.RunConfigurations.TestInProgress2),
    UNPREPARING(J2EEBundle.message("deployment.status.name.unpreparing", new Object[0]), J2EEBundle.message("deployment.status.description.unpreparing", new Object[0]), AllIcons.RunConfigurations.TestInProgress2),
    UNKNOWN(J2EEBundle.message("deployment.status.name.unknown", new Object[0]), J2EEBundle.message("deployment.status.description.unknown", new Object[0]), AllIcons.RunConfigurations.TestUnknown),
    DISCONNECTED(J2EEBundle.message("deployment.status.name.disconnected", new Object[0]), J2EEBundle.message("deployment.status.description.disconnected", new Object[0]), AllIcons.Nodes.Plugin),
    EXCLUDED_FROM_DEPLOYMENT(J2EEBundle.message("deployment.status.name.excluded.from.deployment", new Object[0]), J2EEBundle.message("deployment.status.description.excluded.from.deployment", new Object[0]), null){
        private final Map<Icon, LayeredIcon> myPatchedIcon = new HashMap<Icon, LayeredIcon>();

        @Override
        public Icon getIcon(Icon deploymentIcon) {
            LayeredIcon icon = this.myPatchedIcon.get(deploymentIcon);
            if (icon == null) {
                icon = new LayeredIcon(2);
                icon.setIcon(deploymentIcon, 0);
                icon.setIcon(PlatformIcons.EXCLUDED_FROM_COMPILE_ICON, 1);
                this.myPatchedIcon.put(deploymentIcon, icon);
            }
            return icon;
        }
    };

    private final String myName;
    private final String myDescription;
    private final Icon myIcon;

    private DeploymentStatus(String name, String description, Icon icon) {
        this.myName = name;
        this.myDescription = description;
        this.myIcon = icon;
    }

    public String toString() {
        return this.myName;
    }

    public Icon getIcon(Icon deploymentIcon) {
        return this.myIcon;
    }

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }
}

