/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.operations;

import java.util.ArrayList;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.operations.FileOperation;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.operations.FileOperations;

public class DefaultFileOperations
implements FileOperations {
    private final FileSystemManager fsmanager;
    private final FileObject fileObject;

    public DefaultFileOperations(FileObject file) {
        this.fileObject = file;
        this.fsmanager = file.getFileSystem().getFileSystemManager();
    }

    @Override
    public Class<? extends FileOperation>[] getOperations() throws FileSystemException {
        String scheme = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] providers = this.fsmanager.getOperationProviders(scheme);
        if (providers == null) {
            return null;
        }
        ArrayList<Class<? extends FileOperation>> operations = new ArrayList<Class<? extends FileOperation>>();
        for (FileOperationProvider provider : providers) {
            provider.collectOperations(operations, this.fileObject);
        }
        Class[] array = operations.toArray(new Class[0]);
        return array;
    }

    @Override
    public FileOperation getOperation(Class<? extends FileOperation> operationClass) throws FileSystemException {
        FileOperationProvider provider;
        String scheme = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] providers = this.fsmanager.getOperationProviders(scheme);
        if (providers == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", (Object)operationClass);
        }
        FileOperation resultOperation = null;
        FileOperationProvider[] fileOperationProviderArray = providers;
        int n = fileOperationProviderArray.length;
        for (int i = 0; i < n && (resultOperation = (provider = fileOperationProviderArray[i]).getOperation(this.fileObject, operationClass)) == null; ++i) {
        }
        if (resultOperation == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", (Object)operationClass);
        }
        return resultOperation;
    }

    @Override
    public boolean hasOperation(Class<? extends FileOperation> operationClass) throws FileSystemException {
        Class<? extends FileOperation>[] operations = this.getOperations();
        if (operations == null) {
            return false;
        }
        for (Class<? extends FileOperation> operation : operations) {
            if (!operationClass.isAssignableFrom(operation)) continue;
            return true;
        }
        return false;
    }
}

