/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importer.EclipseImportMap;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileElements;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileReader;

public class EclipseCodeStyleImportWorker
implements EclipseXmlProfileElements {
    private static final Logger LOG = Logger.getInstance(EclipseCodeStyleImportWorker.class);
    static final String PROGRAMMATIC_IMPORT_KEY = "<Programmatic>";
    private final EclipseImportMap myImportMap = new EclipseImportMap();

    public EclipseCodeStyleImportWorker() {
        this.myImportMap.load();
    }

    public void importScheme(@NotNull InputStream inputStream, final @Nullable String sourceScheme, CodeStyleScheme scheme) throws SchemeImportException {
        if (inputStream == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(0);
        }
        final CodeStyleSettings settings = scheme.getCodeStyleSettings();
        EclipseXmlProfileReader reader = new EclipseXmlProfileReader(new EclipseXmlProfileReader.OptionHandler(){
            private String myCurrScheme;

            @Override
            public void handleOption(@NotNull String eclipseKey, @NotNull String value) throws SchemeImportException {
                if (eclipseKey == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sourceScheme == null || this.myCurrScheme != null && this.myCurrScheme.equals(sourceScheme)) {
                    EclipseCodeStyleImportWorker.this.setCodeStyleOption(settings, eclipseKey, value);
                }
            }

            @Override
            public void handleName(String name) {
                this.myCurrScheme = name;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "eclipseKey";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleImportWorker$1";
                objectArray[2] = "handleOption";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        reader.readSettings(inputStream);
    }

    private void setCodeStyleOption(@NotNull CodeStyleSettings settings, @NotNull String key, @NotNull String value) throws SchemeImportException {
        EclipseImportMap.ImportDescriptor importDescriptor;
        if (settings == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(1);
        }
        if (key == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(2);
        }
        if (value == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(3);
        }
        if ((importDescriptor = this.myImportMap.getImportDescriptor(key)) != null) {
            try {
                if (importDescriptor.isLanguageSpecific()) {
                    if (importDescriptor.isCustomField()) {
                        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
                        EclipseCodeStyleImportWorker.setValue(javaSettings, key, importDescriptor.getFieldName(), value);
                    } else {
                        CommonCodeStyleSettings languageSettings = settings.getCommonSettings(importDescriptor.getLanguage());
                        if (languageSettings != null) {
                            if (importDescriptor.isIndentOptions()) {
                                CommonCodeStyleSettings.IndentOptions indentOptions = languageSettings.getIndentOptions();
                                if (indentOptions != null) {
                                    EclipseCodeStyleImportWorker.setValue(indentOptions, key, importDescriptor.getFieldName(), value);
                                }
                            } else {
                                EclipseCodeStyleImportWorker.setValue(languageSettings, key, importDescriptor.getFieldName(), value);
                            }
                        }
                    }
                } else {
                    EclipseCodeStyleImportWorker.setValue(settings, key, importDescriptor.getFieldName(), value);
                }
            }
            catch (Exception e) {
                throw new SchemeImportException((Throwable)e);
            }
        }
    }

    private static void setValue(Object object, String key, String fieldName, String value) throws SchemeImportException {
        if (PROGRAMMATIC_IMPORT_KEY.equalsIgnoreCase(fieldName)) {
            EclipseCodeStyleImportWorker.setProgrammatically(object, key, value);
            return;
        }
        try {
            Field targetField = object.getClass().getField(fieldName);
            Class<?> fieldType = targetField.getType();
            if (fieldType.isPrimitive()) {
                if (Boolean.TYPE.equals(fieldType)) {
                    targetField.setBoolean(object, EclipseCodeStyleImportWorker.valueToBoolean(key, value));
                } else if (Integer.TYPE.equals(fieldType)) {
                    targetField.setInt(object, EclipseCodeStyleImportWorker.valueToInt(value));
                }
            } else if (fieldType.equals(String.class)) {
                targetField.set(object, value);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOG.error("Field '" + fieldName + "' does not exist in " + object.getClass().getName(), (Throwable)e);
        }
    }

    private static boolean valueToBoolean(@NotNull String key, @NotNull String value) throws SchemeImportException {
        if (key == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(4);
        }
        if (value == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(5);
        }
        if ("insert".equals(value) || "true".equals(value)) {
            return true;
        }
        if (!"do not insert".equals(value) && !"false".equals(value)) {
            throw new SchemeImportException("Unrecognized boolean value: " + value + ", key: " + key);
        }
        return false;
    }

    private static int valueToInt(@NotNull String value) {
        if (value == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(6);
        }
        if ("end_of_line".equals(value)) {
            return 1;
        }
        if ("next_line".equals(value)) {
            return 2;
        }
        if ("next_line_shifted".equals(value)) {
            return 3;
        }
        if ("next_line_on_wrap".equals(value)) {
            return 5;
        }
        return Integer.parseInt(value);
    }

    private static void setProgrammatically(@NotNull Object object, @NotNull String key, @NotNull String value) throws SchemeImportException {
        if (object == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(7);
        }
        if (key == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(8);
        }
        if (value == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(9);
        }
        if (key.contains("alignment") && value.matches("\\d*") && object instanceof CommonCodeStyleSettings && EclipseCodeStyleImportWorker.setAlignmentAndWrappingOptions((CommonCodeStyleSettings)object, key, value)) {
            return;
        }
        if (object instanceof CodeStyleSettings) {
            CodeStyleSettings settings = (CodeStyleSettings)object;
            if ("org.eclipse.jdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment".equals(key)) {
                ((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).JD_KEEP_EMPTY_LINES = !EclipseCodeStyleImportWorker.valueToBoolean(key, value);
            } else if ("org.eclipse.jdt.core.formatter.insert_new_line_at_end_of_file_if_missing".equals(key)) {
                EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
                editorSettings.setEnsureNewLineAtEOF(EclipseCodeStyleImportWorker.valueToBoolean(key, value));
            }
        } else if (object instanceof CommonCodeStyleSettings) {
            CommonCodeStyleSettings commonSettings = (CommonCodeStyleSettings)object;
            if ("org.eclipse.jdt.core.formatter.insert_space_after_binary_operator".equals(key)) {
                boolean addSpace;
                commonSettings.SPACE_AROUND_SHIFT_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = (addSpace = EclipseCodeStyleImportWorker.valueToBoolean(key, value));
                commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
                commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
                commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
                commonSettings.SPACE_AROUND_BITWISE_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
                commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
            } else if ("org.eclipse.jdt.core.formatter.indent_body_declarations_compare_to_type_header".equals(key)) {
                commonSettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = !EclipseCodeStyleImportWorker.valueToBoolean(key, value);
            } else if ("org.eclipse.jdt.core.formatter.blank_lines_before_first_class_body_declaration".equals(key)) {
                int intValue;
                commonSettings.BLANK_LINES_AFTER_CLASS_HEADER = intValue = EclipseCodeStyleImportWorker.valueToInt(value);
                commonSettings.BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER = intValue;
            } else if ("org.eclipse.jdt.core.formatter.number_of_empty_lines_to_preserve".equals(key)) {
                int intValue;
                commonSettings.KEEP_BLANK_LINES_IN_CODE = intValue = EclipseCodeStyleImportWorker.valueToInt(value);
                commonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = intValue;
                commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = intValue;
            } else if ("org.eclipse.jdt.core.formatter.insert_space_after_closing_brace_in_block".equals(key)) {
                boolean insertSpace;
                commonSettings.SPACE_BEFORE_ELSE_KEYWORD = insertSpace = EclipseCodeStyleImportWorker.valueToBoolean(key, value);
                commonSettings.SPACE_BEFORE_CATCH_KEYWORD = insertSpace;
                commonSettings.SPACE_BEFORE_FINALLY_KEYWORD = insertSpace;
            } else if ("org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block".equals(key)) {
                boolean insertSpace;
                commonSettings.SPACE_BEFORE_IF_LBRACE = insertSpace = EclipseCodeStyleImportWorker.valueToBoolean(key, value);
                commonSettings.SPACE_BEFORE_FOR_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_WHILE_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_DO_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_TRY_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_CATCH_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_FINALLY_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE = insertSpace;
            } else if ("org.eclipse.jdt.core.formatter.join_wrapped_lines".equals(key)) {
                commonSettings.KEEP_LINE_BREAKS = !EclipseCodeStyleImportWorker.valueToBoolean(key, value);
            }
        } else if (object instanceof CommonCodeStyleSettings.IndentOptions) {
            CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)object;
            if ("org.eclipse.jdt.core.formatter.tabulation.char".equals(key)) {
                if ("tab".equals(value) || "mixed".equals(value)) {
                    indentOptions.USE_TAB_CHARACTER = true;
                } else if ("space".equals(value)) {
                    indentOptions.USE_TAB_CHARACTER = false;
                }
            } else if ("org.eclipse.jdt.core.formatter.continuation_indentation".equals(key)) {
                indentOptions.CONTINUATION_INDENT_SIZE = indentOptions.TAB_SIZE * EclipseCodeStyleImportWorker.valueToInt(value);
            } else if ("org.eclipse.jdt.core.formatter.tabulation.size".equals(key)) {
                int newTabSize = EclipseCodeStyleImportWorker.valueToInt(value);
                int continuationTabs = indentOptions.TAB_SIZE > 0 ? indentOptions.CONTINUATION_INDENT_SIZE / indentOptions.TAB_SIZE : -1;
                indentOptions.TAB_SIZE = newTabSize;
                if (continuationTabs >= 0) {
                    indentOptions.CONTINUATION_INDENT_SIZE = continuationTabs * newTabSize;
                }
            }
        }
    }

    private static boolean setAlignmentAndWrappingOptions(@NotNull CommonCodeStyleSettings settings, @NotNull String key, @NotNull String value) {
        if (settings == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(10);
        }
        if (key == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(11);
        }
        if (value == null) {
            EclipseCodeStyleImportWorker.$$$reportNull$$$0(12);
        }
        int encodedValue = Integer.parseInt(value);
        AlignmentAndWrapValueDecoder decoder = new AlignmentAndWrapValueDecoder(encodedValue);
        if ("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_annotation".equals(key)) {
            settings.VARIABLE_ANNOTATION_WRAP = settings.CLASS_ANNOTATION_WRAP = decoder.getWrapType();
            settings.PARAMETER_ANNOTATION_WRAP = settings.CLASS_ANNOTATION_WRAP;
            settings.METHOD_ANNOTATION_WRAP = settings.CLASS_ANNOTATION_WRAP;
            settings.FIELD_ANNOTATION_WRAP = settings.CLASS_ANNOTATION_WRAP;
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_expressions_in_array_initializer".equals(key)) {
            settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = decoder.isAlignmentOn();
            settings.ARRAY_INITIALIZER_WRAP = decoder.getWrapType();
            settings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = decoder.isFirstElementWrapped();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_method_invocation".equals(key)) {
            settings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = decoder.isAlignmentOn();
            settings.CALL_PARAMETERS_WRAP = decoder.getWrapType();
            settings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = decoder.isFirstElementWrapped();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_superinterfaces_in_type_declaration".equals(key)) {
            settings.ALIGN_MULTILINE_EXTENDS_LIST = decoder.isAlignmentOn();
            settings.EXTENDS_KEYWORD_WRAP = decoder.getFirstElementWrapType();
            settings.EXTENDS_LIST_WRAP = decoder.getWrapType();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_assignment".equals(key)) {
            settings.ALIGN_MULTILINE_ASSIGNMENT = decoder.isAlignmentOn();
            settings.ASSIGNMENT_WRAP = decoder.getWrapType();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_parameters_in_method_declaration".equals(key)) {
            settings.ALIGN_MULTILINE_PARAMETERS = decoder.isAlignmentOn();
            settings.METHOD_PARAMETERS_WRAP = decoder.getWrapType();
            settings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = decoder.isFirstElementWrapped();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_binary_expression".equals(key)) {
            settings.ALIGN_MULTILINE_BINARY_OPERATION = decoder.isAlignmentOn();
            settings.BINARY_OPERATION_WRAP = decoder.getWrapType();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_throws_clause_in_method_declaration".equals(key)) {
            settings.ALIGN_MULTILINE_THROWS_LIST = decoder.isAlignmentOn();
            settings.THROWS_KEYWORD_WRAP = decoder.getFirstElementWrapType();
            settings.THROWS_LIST_WRAP = decoder.getWrapType();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_resources_in_try".equals(key)) {
            settings.ALIGN_MULTILINE_RESOURCES = decoder.isAlignmentOn();
            settings.RESOURCE_LIST_WRAP = decoder.getWrapType();
            settings.RESOURCE_LIST_LPAREN_ON_NEXT_LINE = decoder.isFirstElementWrapped();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_selector_in_method_invocation".equals(key)) {
            settings.METHOD_CALL_CHAIN_WRAP = decoder.getWrapType();
            settings.ALIGN_MULTILINE_CHAINED_METHODS = decoder.isAlignmentOn();
        } else if ("org.eclipse.jdt.core.formatter.alignment_for_conditional_expression".equals(key)) {
            settings.TERNARY_OPERATION_WRAP = decoder.getWrapType();
            settings.ALIGN_MULTILINE_TERNARY_OPERATION = decoder.isAlignmentOn();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleImportWorker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "importScheme";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setCodeStyleOption";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "valueToBoolean";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "valueToInt";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setProgrammatically";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setAlignmentAndWrappingOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AlignmentAndWrapValueDecoder {
        int myEncodedValue;

        public AlignmentAndWrapValueDecoder(int encodedValue) {
            this.myEncodedValue = encodedValue;
        }

        public int getWrapType() {
            switch (this.getEclipseWrap()) {
                case 16: 
                case 32: {
                    return 1;
                }
                case 48: 
                case 64: 
                case 80: {
                    return 5;
                }
            }
            return 0;
        }

        public int getFirstElementWrapType() {
            return this.isNewLineBeforeFirst() ? 2 : (this.getEclipseWrap() == 80 ? 0 : 1);
        }

        public boolean isFirstElementWrapped() {
            int eclipseWrapValue = this.getEclipseWrap();
            return eclipseWrapValue == 32 || eclipseWrapValue == 64 || eclipseWrapValue == 48 || this.isNewLineBeforeFirst();
        }

        public boolean isNewLineBeforeFirst() {
            return (this.myEncodedValue & 1) != 0;
        }

        public boolean isAlignmentOn() {
            return (this.myEncodedValue & 2) != 0;
        }

        public int getEclipseWrap() {
            return this.myEncodedValue & 0x70;
        }
    }
}

