/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.LinkedHashSet;
import org.coffeescript.CsBundle;
import org.coffeescript.file.CoffeeScriptFileType;
import org.coffeescript.refactoring.CoffeeScriptChangeUtil;
import org.coffeescript.refactoring.CoffeeScriptIntroduceHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptIntroduceVariableHandler
extends CoffeeScriptIntroduceHandler {
    @Override
    protected void processIntroduce(@NotNull Editor editor, final @NotNull PsiElement element) {
        PsiElement block;
        PsiElement current;
        if (editor == null) {
            CoffeeScriptIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CoffeeScriptIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        for (current = element; current != null && current.getParent() != null && !(current.getParent() instanceof JSBlockStatement) && !(current.getParent() instanceof PsiFile); current = current.getParent()) {
        }
        PsiElement psiElement = block = current != null ? current.getParent() : null;
        if (block == null) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)CsBundle.message("refactorings.introduce.cant.introduce.message", new Object[0]), (String)CsBundle.message("refactorings.introduce.cant.introduce.title", new Object[0]), (String)"refactoring.extract.variable.coffeescript");
            return;
        }
        final PsiElement anchor = current;
        final JSVarStatement varStatement = (JSVarStatement)CoffeeScriptChangeUtil.createElementFromText("variable = " + element.getText(), (FileType)CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE, element.getProject());
        assert (varStatement != null);
        final PsiElement variableReference = CoffeeScriptChangeUtil.createElementFromText("variable", (FileType)CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE, element.getProject());
        assert (variableReference != null);
        PsiElement lineBreakBeforeProcessingElement = element.getPrevSibling();
        String lineBreakText = lineBreakBeforeProcessingElement != null ? lineBreakBeforeProcessingElement.getText() : "\n";
        final PsiElement lineBreak = PsiParserFacade.SERVICE.getInstance((Project)element.getProject()).createWhiteSpaceFromText(lineBreakText);
        SmartPsiElementPointer addedVarStatementPointer = (SmartPsiElementPointer)new WriteCommandAction<SmartPsiElementPointer>(element.getProject(), new PsiFile[]{element.getContainingFile()}){

            protected void run(@NotNull Result<SmartPsiElementPointer> result) throws Throwable {
                JSVarStatement insertedVarStatement;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element.getParent() instanceof JSExpressionStatement) {
                    insertedVarStatement = (JSVarStatement)element.replace((PsiElement)varStatement);
                } else {
                    insertedVarStatement = (JSVarStatement)block.addBefore((PsiElement)varStatement, anchor);
                    block.addBefore(lineBreak, anchor);
                    element.replace(variableReference);
                }
                SmartPsiElementPointer resultPointer = SmartPointerManager.getInstance((Project)insertedVarStatement.getProject()).createSmartPsiElementPointer((PsiElement)insertedVarStatement);
                result.setResult((Object)resultPointer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/coffeescript/refactoring/CoffeeScriptIntroduceVariableHandler$1", "run"));
            }
        }.execute().getResultObject();
        JSVarStatement addedVarStatement = (JSVarStatement)addedVarStatementPointer.getElement();
        assert (addedVarStatement != null);
        final JSVariable updatedVariable = (JSVariable)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)addedVarStatement.getVariables()[0]);
        InplaceVariableIntroducer<PsiElement> introducer = new InplaceVariableIntroducer<PsiElement>((PsiNamedElement)updatedVariable, editor, varStatement.getProject(), CsBundle.message("refactorings.introduce.variable.title", new Object[0]), new PsiElement[]{variableReference}, null){

            @Nullable
            protected PsiElement checkLocalScope() {
                return updatedVariable.getContainingFile();
            }
        };
        if (updatedVariable != null) {
            LinkedHashSet<String> variants = new LinkedHashSet<String>();
            variants.add("variable");
            editor.getCaretModel().moveToOffset(updatedVariable.getTextOffset());
            introducer.performInplaceRefactoring(variants);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "org/coffeescript/refactoring/CoffeeScriptIntroduceVariableHandler";
        objectArray[2] = "processIntroduce";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

