/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.highlighter;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSCheckFunctionSignaturesInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.CsBundle;
import org.coffeescript.codeinsight.inspections.CoffeeScriptArgumentsOutsideFunctionInspection;
import org.coffeescript.highlighter.CoffeeScriptSyntaxHighlighter;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptAnnotatingVisitor
extends JSAnnotatingVisitor {
    final List<IElementType> OPERATOR_KEYWORDS;

    public CoffeeScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
        this.OPERATOR_KEYWORDS = Arrays.asList(JSTokenTypes.ANDAND, JSTokenTypes.OROR, JSTokenTypes.EXCL, CoffeeScriptTokenTypes.EQ_EQ_EQ, CoffeeScriptTokenTypes.NOT_EQ_EQ);
    }

    @NotNull
    protected JSFunctionSignatureChecker createFunctionSignatureChecker(PsiElement context) {
        CoffeeScriptFunctionSignatureChecker coffeeScriptFunctionSignatureChecker = new CoffeeScriptFunctionSignatureChecker(this.myTypeChecker);
        if (coffeeScriptFunctionSignatureChecker == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        return coffeeScriptFunctionSignatureChecker;
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        PsiElement operator;
        if (node instanceof JSBinaryExpressionImpl && (operator = ((JSBinaryExpressionImpl)node).getOperator()) != null && this.OPERATOR_KEYWORDS.contains(operator.getNode().getElementType()) && StringUtil.containsAlphaCharacters((String)operator.getText())) {
            this.myHolder.createInfoAnnotation(operator, null).setTextAttributes(CoffeeScriptSyntaxHighlighter.KEYWORD);
        }
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (this.OPERATOR_KEYWORDS.contains(node.getOperationSign())) {
            this.myHolder.createInfoAnnotation(node.getFirstChild(), null).setTextAttributes(CoffeeScriptSyntaxHighlighter.KEYWORD);
        }
    }

    protected boolean needsInitializer(JSParameterListElement parameter) {
        return false;
    }

    protected Annotation reportUnresolvedRefProblem(ProblemHighlightType unresolveReferenceHighlightType, List<LocalQuickFix> quickFixes, @NotNull PsiElement referenceNameElement, @NotNull String message, String inspectionId) {
        if (referenceNameElement == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        if (message == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        return super.reportUnresolvedRefProblem(unresolveReferenceHighlightType, Collections.emptyList(), referenceNameElement, message, inspectionId);
    }

    protected void checkCallReferences(JSCallExpression node, JSReferenceExpression referenceExpression) {
        ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
        if (resolveResults.length != 1 || !(resolveResults[0].getElement() instanceof JSVariable) || referenceExpression.getQualifier() != null) {
            super.checkCallReferences(node, referenceExpression);
        }
    }

    public void visitJSParameter(JSParameter node) {
        JSFunction function;
        super.visitJSParameter(node);
        if (node.getText().startsWith("@") && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunctionExpression.class)) != null && CoffeeScriptUtil.canHoldImplicitProperties(function)) {
            this.myHolder.createInfoAnnotation(node.getLastChild(), null).setTextAttributes(CoffeeScriptSyntaxHighlighter.GLOBAL_VARIABLE);
        }
    }

    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
        if (node == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(5);
        }
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (!CoffeeScriptArgumentsOutsideFunctionInspection.argumentsOutsideFunction(node)) {
            super.visitJSReferenceExpression(node);
        }
    }

    protected void registerQuickFixesForUnresolvedRef(JSReferenceExpression node, ResolveResult[] resolveResults) {
        if (node.getParent() instanceof JSDefinitionExpression) {
            return;
        }
        super.registerQuickFixesForUnresolvedRef(node, resolveResults);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceNameElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionSignatureChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedRefProblem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReturnStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CoffeeScriptFunctionSignatureChecker
    extends JSFunctionSignatureChecker {
        public CoffeeScriptFunctionSignatureChecker(JSTypeChecker typeChecker) {
            super(typeChecker);
        }

        protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
            PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem((JSCallExpression)callExpression, (JSArgumentList)callExpression.getArgumentList());
            CoffeeScriptAnnotatingVisitor.this.myProblemReporter.registerProblem(place, message, null, JSCheckFunctionSignaturesInspection.SHORT_NAME, fixes);
        }

        public void checkConstructorCall(@NotNull JSCallExpression node, @NotNull JSClass target) {
            JSFunction constructor;
            if (node == null) {
                CoffeeScriptFunctionSignatureChecker.$$$reportNull$$$0(0);
            }
            if (target == null) {
                CoffeeScriptFunctionSignatureChecker.$$$reportNull$$$0(1);
            }
            if ((constructor = target.getConstructor()) != null) {
                int mandatoryParameters = constructor.getParameterVariables().length;
                for (JSParameter parameter : constructor.getParameterVariables()) {
                    if (!parameter.isOptional()) continue;
                    --mandatoryParameters;
                }
                this.reportProblemIfNotExpectedCountOfParameters(node, mandatoryParameters, constructor.getParameters().length);
            }
        }

        public void reportProblemIfNotExpectedCountOfParameters(JSCallExpression node, int minCount, int maxCount) {
            JSExpression[] arguments = node.getArguments();
            if (arguments.length < minCount || arguments.length > maxCount) {
                if (minCount == maxCount) {
                    this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{minCount}), new LocalQuickFix[0]);
                } else {
                    this.registerProblem(node, CsBundle.message("inspection.invalid.number.of.parameters.range", minCount, maxCount), new LocalQuickFix[0]);
                }
            }
        }

        protected void checkCallParameters(@NotNull JSCallExpression call, @Nullable PsiElement element, LocalQuickFix[] quickFixes) {
            JSArgumentList argumentList;
            if (call == null) {
                CoffeeScriptFunctionSignatureChecker.$$$reportNull$$$0(2);
            }
            if (element instanceof JSFunction) {
                for (JSParameter parameter : ((JSFunction)element).getParameterVariables()) {
                    if (parameter.getNode().findChildByType(CoffeeScriptTokenTypes.SPLAT) == null) continue;
                    return;
                }
            }
            if ((argumentList = call.getArgumentList()) != null && argumentList.getNode().findChildByType(CoffeeScriptTokenTypes.SPLAT) != null) {
                return;
            }
            super.checkCallParameters(call, element, quickFixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor$CoffeeScriptFunctionSignatureChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkConstructorCall";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCallParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

