/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.formatter.blocks;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.coffeescript.formatter.CoffeeScriptCodeStyleSettings;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;

public class CoffeeScriptSpacingProcessor
extends JSSpacingProcessor {
    private static final String EXCL_WORD = "not";
    private CoffeeScriptCodeStyleSettings myCoffeeScriptCodeStyleSettings;

    public CoffeeScriptSpacingProcessor(ASTNode parent, ASTNode child1, ASTNode child2, CodeStyleSettings settings, Language dialect) {
        super(parent, child1, child2, settings, dialect, (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class));
        this.myCoffeeScriptCodeStyleSettings = (CoffeeScriptCodeStyleSettings)settings.getCustomSettings(CoffeeScriptCodeStyleSettings.class);
    }

    public void visitArrayLiteralExpression(ASTNode node) {
        super.visitArrayLiteralExpression(node);
        if (this.type1 == JSTokenTypes.LBRACKET && this.type2 == JSTokenTypes.RBRACKET) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES && (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET)) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    public void visitElement(ASTNode node) {
        super.visitElement(node);
        if (node.getElementType() == CoffeeScriptElementTypes.RANGE) {
            if (this.myCoffeeScriptCodeStyleSettings.SPACE_WITHIN_RANGE_BRACKETS && (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET)) {
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (node.getElementType() == CoffeeScriptElementTypes.VARIABLE) {
            super.visitVariable(node);
            if (this.type1 == CoffeeScriptTokenTypes.EQ || this.type2 == CoffeeScriptTokenTypes.EQ) {
                boolean keepBlankLines = this.type2 == CoffeeScriptElementTypes.OBJECT ? true : this.mySettings.KEEP_LINE_BREAKS;
                int spaceCount = this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)spaceCount, (int)spaceCount, (int)0, (boolean)keepBlankLines, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }
    }

    public void visitIndexedPropertyAccessExpression(ASTNode node) {
        super.visitIndexedPropertyAccessExpression(node);
        if (this.myCoffeeScriptCodeStyleSettings.SPACE_WITHIN_INDEX_BRACKETS && (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET)) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    public void visitObjectLiteralExpression(ASTNode node) {
        super.visitObjectLiteralExpression(node);
        if (this.type1 == JSTokenTypes.LBRACE && this.type2 == JSTokenTypes.RBRACE) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myCoffeeScriptCodeStyleSettings.SPACE_WITHIN_OBJECT_BRACES && (this.type1 == JSTokenTypes.LBRACE || this.type2 == JSTokenTypes.RBRACE)) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    protected boolean getSpaceAroundOption(IElementType opSign) {
        if (opSign == JSTokenTypes.EXCL && (this.myChild1.getText().equals(EXCL_WORD) || this.myChild2.getText().equals(EXCL_WORD))) {
            return true;
        }
        return super.getSpaceAroundOption(opSign);
    }

    protected void setUnaryOperatorSpacing(IElementType opType) {
        if (this.myChild1.getElementType() == JSTokenTypes.EXCL && this.myChild1.getTextLength() > 1) {
            this.setSingleSpace(true);
        } else {
            super.setUnaryOperatorSpacing(opType);
        }
    }

    protected void setBraceSpace(boolean needSpaceSetting, int braceStyleSetting, TextRange textRange) {
        int spaces;
        if (this.type1 == JSTokenTypes.END_OF_LINE_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            return;
        }
        int n = spaces = needSpaceSetting ? 1 : 0;
        if (braceStyleSetting == 5 && textRange != null) {
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            int lineBreaks = braceStyleSetting == 1 || braceStyleSetting == 5 ? 0 : 1;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)lineBreaks, (boolean)true, (int)0);
        }
    }

    public void visitCallExpression(ASTNode node) {
        if (this.myChild2 != null && this.myChild2.getText().startsWith("(")) {
            if (this.type2 == JSElementTypes.ARGUMENT_LIST) {
                ASTNode nodeBetween = this.myChild1.getTreeNext();
                this.setSingleSpace(nodeBetween != null && nodeBetween.getElementType() == JSTokenTypes.WHITE_SPACE);
            }
        } else {
            this.setSingleSpace(true);
        }
    }

    public void visitParameterList(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, false, 0);
        } else if (this.type2 == JSTokenTypes.RPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, false, 0);
        } else {
            super.visitParameterList(node);
        }
    }

    public void visitArgumentList(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type2 == JSTokenTypes.RPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else {
            super.visitArgumentList(node);
        }
    }

    public void visitProperty(ASTNode node) {
        if (this.type2 == JSTokenTypes.COLON) {
            int spaces = this.myCoffeeScriptCodeStyleSettings.SPACE_BEFORE_PROPERTY_COLON ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else if (this.type1 == JSTokenTypes.COLON) {
            int spaces = this.myCoffeeScriptCodeStyleSettings.SPACE_AFTER_PROPERTY_COLON ? 1 : 0;
            boolean withBraces = this.myChild2.getFirstChildNode() != null && this.myChild2.getFirstChildNode().getElementType() == CoffeeScriptTokenTypes.BRACE_START;
            this.myResult = this.myChild2.getElementType() == JSElementTypes.OBJECT_LITERAL_EXPRESSION && !withBraces ? Spacing.createSpacing((int)spaces, (int)spaces, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0) : Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        }
    }

    public void visitFunctionDeclaration(ASTNode node) {
        super.visitFunctionDeclaration(node);
        if (this.type2 == CoffeeScriptElementTypes.INDENT_BLOCK) {
            if (this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE) {
                this.myResult = Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (this.type2 == CoffeeScriptElementTypes.EXPRESSION_STATEMENT && !this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE && !this.myChild2.getText().contains("\n")) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    public void visitIfStatement(ASTNode node) {
        ASTNode thenKeyword;
        super.visitIfStatement(node);
        if (this.type2 == JSTokenTypes.ELSE_KEYWORD && (thenKeyword = TreeUtil.findSiblingBackward((ASTNode)this.myChild2, (IElementType)CoffeeScriptTokenTypes.THEN)) != null) {
            this.setLineBreakSpace(false, this.mySettings.SPACE_BEFORE_ELSE_KEYWORD);
        }
    }

    public void visitCaseClause(ASTNode node) {
        if (this.type1 == CoffeeScriptTokenTypes.THEN) {
            this.setSingleSpace(true);
            return;
        }
        super.visitCaseClause(node);
    }

    public void visitFile(ASTNode node) {
        if (!this.processSemicolonOrComment()) {
            super.visitFile(node);
        }
    }

    public void visitVariable(ASTNode node) {
        super.visitVariable(node);
        this.processAssignmentStatement();
    }

    public void visitLocalVariable(ASTNode node) {
        super.visitLocalVariable(node);
        this.processAssignmentStatement();
    }

    public void visitAssignmentExpression(ASTNode node) {
        super.visitAssignmentExpression(node);
        this.processAssignmentStatement();
    }

    protected void processBlock() {
        if (!this.processSemicolonOrComment()) {
            super.processBlock();
        }
    }

    private void processAssignmentStatement() {
        ASTNode probableBrace;
        if (this.type1 == CoffeeScriptTokenTypes.EQ && this.type2 == JSElementTypes.OBJECT_LITERAL_EXPRESSION && (probableBrace = this.myChild2.getFirstChildNode()) != null && probableBrace.getElementType() == CoffeeScriptElementTypes.PROPERTY) {
            int spaces = this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private boolean processSemicolonOrComment() {
        if (this.type2 == CoffeeScriptTokenTypes.SEMICOLON) {
            this.setSingleSpace(false);
        } else if (this.type2 == CoffeeScriptTokenTypes.LINE_COMMENT) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            return false;
        }
        return true;
    }
}

