/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSLanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.CsBundle;
import org.coffeescript.formatter.CoffeeScriptCodeStyleSettings;
import org.coffeescript.formatter.CoffeeScriptIndentOptionsEditor;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final String[] STANDARD_SPACING_OPTIONS = new String[]{"SPACE_AFTER_COMMA", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_BEFORE_COMMA", "SPACE_BEFORE_TYPE", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_AROUND_UNARY_OPERATOR", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_ARRAY_INITIALIZER_BRACES"};
    public static final String[] STANDARD_WRAPPING_OPTIONS = new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT", "KEEP_SIMPLE_METHODS_IN_ONE_LINE", "METHOD_PARAMETERS_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_PARAMETERS", "CALL_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", "ARRAY_INITIALIZER_WRAP", "ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE"};
    private static final String WRAPPING_CODE_SAMPLE = "everybody =\n  come * take + my * hand\n\narr = [\"We'll walk this road together\", \"through the storm\", \"Whatever weather, cold or warm\"]\n\nif something(happened)\n  #When I say I'ma do something I do it\n  do_something()\n\nfeed = (it, beans) ->\n  its = gassed + up\n\nfeed(it, beans)\n\nso = (starting) -> today \"I'm breaking out of this cage\"\nbutton =\n  img: \"btn.gif\"\n  text: \"Button\"\n  width: 128\n";
    public static final String[] STANDARD_BLANK_LINES_OPTIONS = new String[]{"KEEP_BLANK_LINES_IN_CODE"};
    private static final String GENERAL_CODE_SAMPLE = "# Assignment:\nnumber = 42\nopposite = true\n\n# Conditions:\nnumber = -42 if opposite\n\n# Functions:\nsquare = (x) ->\n  x * x\n\n\n# Arrays:\nlist = [1, 2, 3, 4, 5]\n\n\n# Objects:\nmath =\n  root: Math.sqrt\n  square: square\n  cube: (x) ->\n    x * square x\n\n\n# Splats:\nrace = (winner, runners...) ->\n  print winner, runners\n\n\n# Existence:\nalert \"I knew it!\" if elvis?\n\n\n# Array comprehensions:\ncubes = (math.cube num for num in list)";
    private static final String SPACING_CODE_SAMPLE = "obj = {name: value}\narr = [1, 2, 3, 4]\nfoo = (x, y, z) ->\n  bar 1, b\n  i = 0\n\n  if !i > 10\n    for j in [1..10]\n      switch j\n        when 0\n          value = \"zero\"\n        when 1\n          value = \"one\"\n\n      if j > 5\n        c = \"GT 5\"\n      else\n        c =\"LE 5\"\n  else\n    j = 0\n    try\n      while !(j >= 10)\n        if i == j || j > 5\n          a[j] = i + j * 12\n\n        i = (j << 2)&4\n        j++\n\n      while j > 0\n        j--\n\n    catch e\n      alert(\"Failure: \" + e.message)\n    finally\n      reset(a, i)\n";

    @NotNull
    public Language getLanguage() {
        CoffeeScriptLanguage coffeeScriptLanguage = CoffeeScriptLanguage.INSTANCE;
        if (coffeeScriptLanguage == null) {
            CoffeeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return coffeeScriptLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            CoffeeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        switch (settingsType) {
            case WRAPPING_AND_BRACES_SETTINGS: {
                return WRAPPING_CODE_SAMPLE;
            }
            case BLANK_LINES_SETTINGS: {
                return GENERAL_CODE_SAMPLE;
            }
            case SPACING_SETTINGS: {
                return SPACING_CODE_SAMPLE;
            }
            case INDENT_SETTINGS: {
                return GENERAL_CODE_SAMPLE;
            }
        }
        return GENERAL_CODE_SAMPLE;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            CoffeeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            CoffeeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(STANDARD_SPACING_OPTIONS);
            consumer.showCustomOption(CoffeeScriptCodeStyleSettings.class, "SPACE_BEFORE_PROPERTY_COLON", JSBundle.message((String)"space.before.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(CoffeeScriptCodeStyleSettings.class, "SPACE_AFTER_PROPERTY_COLON", JSBundle.message((String)"space.after.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.renameStandardOption("SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", CsBundle.message("formatter.options.space.within.array", new Object[0]));
            consumer.showCustomOption(CoffeeScriptCodeStyleSettings.class, "SPACE_WITHIN_INDEX_BRACKETS", CsBundle.message("formatter.options.space.within.index", new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(CoffeeScriptCodeStyleSettings.class, "SPACE_WITHIN_RANGE_BRACKETS", CsBundle.message("formatter.options.space.within.range", new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(CoffeeScriptCodeStyleSettings.class, "SPACE_WITHIN_OBJECT_BRACES", CsBundle.message("formatter.options.space.within.object", new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(STANDARD_WRAPPING_OPTIONS);
            consumer.renameStandardOption("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.after.left.bracket", (Object[])new Object[0]));
            consumer.renameStandardOption("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.before.right.bracket", (Object[])new Object[0]));
            consumer.renameStandardOption("METHOD_PARAMETERS_WRAP", JSBundle.message((String)"js.function.parameters.wrap", (Object[])new Object[0]));
            consumer.renameStandardOption("CALL_PARAMETERS_WRAP", CsBundle.message("formatter.options.call.parameters.wrap.title", new Object[0]));
            consumer.showCustomOption(CoffeeScriptCodeStyleSettings.class, "ALIGN_FUNCTION_BODY", CsBundle.message("codestyle.align.function", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(CoffeeScriptCodeStyleSettings.class, "ALIGN_OBJECT_PROPERTIES", JSBundle.message((String)"js.code.style.align.caption", (Object[])new Object[0]), JSBundle.message((String)"js.code.style.object.literals.category.name", (Object[])new Object[0]), new Object[]{JSLanguageCodeStyleSettingsProvider.ALIGN_OBJECT_PROPERTIES_OPTIONS, JSLanguageCodeStyleSettingsProvider.ALIGN_OBJECT_PROPERTIES_VALUES});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(STANDARD_BLANK_LINES_OPTIONS);
        }
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = new CommonCodeStyleSettings(this.getLanguage());
        CommonCodeStyleSettings.IndentOptions indentOptions = commonCodeStyleSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        commonCodeStyleSettings.ARRAY_INITIALIZER_WRAP = 1;
        commonCodeStyleSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = true;
        commonCodeStyleSettings.CATCH_ON_NEW_LINE = true;
        commonCodeStyleSettings.FINALLY_ON_NEW_LINE = true;
        commonCodeStyleSettings.ELSE_ON_NEW_LINE = true;
        commonCodeStyleSettings.CALL_PARAMETERS_WRAP = 1;
        commonCodeStyleSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
        commonCodeStyleSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
        commonCodeStyleSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
        return commonCodeStyleSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new CoffeeScriptIndentOptionsEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/formatter/CoffeeScriptLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/formatter/CoffeeScriptLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

