/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.javascript.folding.JavaScriptFoldingBuilder;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.StringTokenizer;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptFoldingBuilder
extends JavaScriptFoldingBuilder {
    protected ASTNode appendDescriptors(ASTNode node, Document document, List<FoldingDescriptor> descriptors) {
        if (node.getElementType() == CoffeeScriptTokenTypes.BLOCK_COMMENT && node.getTextLength() > 1) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        return super.appendDescriptors(node, document, descriptors);
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType type;
        if (node == null) {
            CoffeeScriptFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CoffeeScriptFoldingBuilder.$$$reportNull$$$0(1);
        }
        if ((type = node.getElementType()) == CoffeeScriptTokenTypes.BLOCK_COMMENT) {
            String text = node.getText();
            StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
            String firstLine = "";
            if (tokenizer.countTokens() > 2) {
                tokenizer.nextToken();
                firstLine = tokenizer.nextToken();
                firstLine = StringUtil.replace((String)firstLine.trim(), (String)"*", (String)"");
            }
            return "### " + firstLine + "... ###";
        }
        return super.getLanguagePlaceholderText(node, range);
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            CoffeeScriptFoldingBuilder.$$$reportNull$$$0(2);
        }
        return false;
    }

    public String getBlockPlaceholderText() {
        return "...";
    }

    @NotNull
    protected String getFoldedTestByProperty(JSProperty candidate) {
        String string = "\"" + candidate.getName() + "\": " + candidate.getValue().getText() + "...";
        if (string == null) {
            CoffeeScriptFoldingBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/editor/CoffeeScriptFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/editor/CoffeeScriptFoldingBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedTestByProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

