/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;

public abstract class ModuleLevelBuilder
extends Builder {
    private final BuilderCategory myCategory;

    protected ModuleLevelBuilder(BuilderCategory category) {
        this.myCategory = category;
    }

    public abstract ExitCode build(CompileContext var1, ModuleChunk var2, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> var3, OutputConsumer var4) throws ProjectBuildException, IOException;

    public boolean shouldHonorFileEncodingForCompilation(File file) {
        return false;
    }

    public List<String> getCompilableFileExtensions() {
        return null;
    }

    public final BuilderCategory getCategory() {
        return this.myCategory;
    }

    public void chunkBuildStarted(CompileContext context, ModuleChunk chunk) {
    }

    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
    }

    public static interface OutputConsumer {
        public void registerOutputFile(@NotNull BuildTarget<?> var1, File var2, Collection<String> var3) throws IOException;

        public void registerCompiledClass(@Nullable BuildTarget<?> var1, CompiledClass var2) throws IOException;

        public Collection<CompiledClass> getTargetCompiledClasses(@NotNull BuildTarget<?> var1);

        @NotNull
        public Map<String, CompiledClass> getCompiledClasses();

        @Nullable
        public BinaryContent lookupClassBytes(String var1);
    }

    public static enum ExitCode {
        NOTHING_DONE,
        OK,
        ABORT,
        ADDITIONAL_PASS_REQUIRED,
        CHUNK_REBUILD_REQUIRED;

    }
}

