/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.LoggerWrapper;
import org.jetbrains.jps.builders.java.dependencyView.NamingContext;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

class DependencyContext
implements NamingContext {
    private static final String STRING_TABLE_NAME = "strings.tab";
    private final PersistentStringEnumerator myEnumerator;
    private final Map<TypeRepr.AbstractType, TypeRepr.AbstractType> myTypeMap = new HashMap<TypeRepr.AbstractType, TypeRepr.AbstractType>();
    private final Map<UsageRepr.Usage, UsageRepr.Usage> myUsageMap = new HashMap<UsageRepr.Usage, UsageRepr.Usage>();
    private final int myEmptyName;

    UsageRepr.Usage getUsage(UsageRepr.Usage u) {
        UsageRepr.Usage r = this.myUsageMap.get(u);
        if (r == null) {
            this.myUsageMap.put(u, u);
            return u;
        }
        return r;
    }

    TypeRepr.AbstractType getType(TypeRepr.AbstractType t) {
        TypeRepr.AbstractType r = this.myTypeMap.get(t);
        if (r != null) {
            return r;
        }
        this.myTypeMap.put(t, t);
        return t;
    }

    void clearMemoryCaches() {
        this.myTypeMap.clear();
        this.myUsageMap.clear();
    }

    static File getTableFile(File rootDir, String name) {
        File file = new File(FileUtil.toSystemIndependentName((String)(rootDir.getAbsoluteFile() + File.separator + name)));
        FileUtil.createIfDoesntExist((File)file);
        return file;
    }

    DependencyContext(File rootDir) throws IOException {
        File file = DependencyContext.getTableFile(rootDir, STRING_TABLE_NAME);
        this.myEnumerator = new PersistentStringEnumerator(file, true);
        this.myEmptyName = this.myEnumerator.enumerate("");
    }

    @Override
    @Nullable
    public String getValue(int s) {
        try {
            return this.myEnumerator.valueOf(s);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public int get(String s) {
        try {
            return StringUtil.isEmpty((String)s) ? this.myEmptyName : this.myEnumerator.enumerate(s);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public void close() {
        try {
            this.myEnumerator.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public void flush() {
        this.myEnumerator.force();
    }

    public LoggerWrapper<Integer> getLogger(final Logger log) {
        return new LoggerWrapper<Integer>(){

            @Override
            public boolean isDebugEnabled() {
                return log.isDebugEnabled();
            }

            @Override
            public void debug(String comment, Integer s) {
                if (log.isDebugEnabled()) {
                    log.debug(comment + DependencyContext.this.getValue(s));
                }
            }

            @Override
            public void debug(String comment, String t) {
                if (log.isDebugEnabled()) {
                    log.debug(comment + t);
                }
            }

            @Override
            public void debug(String comment, boolean t) {
                if (log.isDebugEnabled()) {
                    log.debug(comment + Boolean.toString(t));
                }
            }
        };
    }
}

