/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlCompositeElementTypes;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlSignatureCallableType;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlMacroLoopVariable;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlMacro
extends FtlXmlTag {
    public FtlMacro(@NotNull ASTNode node) {
        if (node == null) {
            FtlMacro.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public String getName() {
        String string = "@" + this.getDirectiveName();
        if (string == null) {
            FtlMacro.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public PsiElement getStartTagNameElement() {
        PsiElement firstChild = this.getFirstChild();
        return firstChild == null ? null : firstChild.getNextSibling();
    }

    @Override
    @Nullable
    public PsiElement getEndTagNameElement() {
        PsiElement before = this.findChildByType((IElementType)FtlElementTypes.END_MACRO_START);
        PsiElement candidate = before == null ? null : before.getNextSibling();
        return candidate != null && candidate.textMatches((CharSequence)this.getDirectiveName()) ? candidate : null;
    }

    @NonNls
    private String getDirectiveName() {
        PsiElement element = this.getStartTagNameElement();
        return element == null ? "" : element.getText();
    }

    @Override
    public String getDirectiveTagName() {
        return "@" + this.getDirectiveName();
    }

    @Nullable
    public FtlCallableType getMacroType() {
        PsiElement element = this.getStartTagNameElement();
        return element instanceof FtlExpression ? FtlPsiUtil.asInstanceOf(((FtlExpression)element).getType(), FtlCallableType.class) : null;
    }

    @Nullable
    public FtlSignatureDirective resolveMacro() {
        return (FtlSignatureDirective)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)true, () -> {
            FtlCallableType type = this.getMacroType();
            return type instanceof FtlSignatureCallableType ? ((FtlSignatureCallableType)type).getDirective() : null;
        });
    }

    @Override
    public boolean needsClosing() {
        if (this.findChildByType((IElementType)FtlElementTypes.EMPTY_MACRO_END) != null) {
            return false;
        }
        return super.needsClosing();
    }

    @NotNull
    public FtlArgumentList getArgumentList() {
        FtlArgumentList ftlArgumentList = (FtlArgumentList)((Object)this.findNotNullChildByClass(FtlArgumentList.class));
        if (ftlArgumentList == null) {
            FtlMacro.$$$reportNull$$$0(2);
        }
        return ftlArgumentList;
    }

    @Override
    public String toString() {
        return FtlCompositeElementTypes.USER_DIRECTIVE.toString();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        FtlMacroLoopVariable[] loopVars;
        int lvCount;
        if (processor == null) {
            FtlMacro.$$$reportNull$$$0(3);
        }
        if (state == null) {
            FtlMacro.$$$reportNull$$$0(4);
        }
        if (place == null) {
            FtlMacro.$$$reportNull$$$0(5);
        }
        if ((lvCount = (loopVars = this.getLoopVariables()).length) > 0 && lastParent != null && lastParent.getStartOffsetInParent() >= loopVars[lvCount - 1].getStartOffsetInParent()) {
            for (FtlMacroLoopVariable variable : loopVars) {
                if (processor.execute((PsiElement)variable, state)) continue;
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public FtlMacroLoopVariable[] getLoopVariables() {
        return (FtlMacroLoopVariable[])this.findChildrenByClass(FtlMacroLoopVariable.class);
    }

    public FtlExpression[] getAllMacroReferences() {
        return (FtlExpression[])this.findChildrenByClass(FtlExpression.class);
    }

    @Nullable
    public FtlExpression getMacroReference() {
        PsiElement element = this.getStartTagNameElement();
        return element instanceof FtlExpression ? (FtlExpression)element : null;
    }

    @Override
    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        ResolveState newState;
        FtlSignatureDirective directive;
        if (lastParent == null && honorAssigns && state.get(FtlQualifiedReference.RESOLVING_MACRO) != Boolean.TRUE && (directive = this.resolveMacro()) != null && (directive.getContainingFile() == this.getContainingFile() || state.get(FtlTemplateType.PROCESSING_NAMESPACE) != null) && !directive.processDeclarationsInside(processor, newState = FtlAssignmentType.allowAssignments(state, FtlAssignmentType.ASSIGN), null, true)) {
            return false;
        }
        return super.processDirectiveDeclarations(processor, state, lastParent, honorAssigns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/directives/FtlMacro";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlMacro";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

