/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlReferenceExpression
extends FtlCompositeElement
implements FtlReferenceQualifier {
    private final FtlQualifiedReference myReference;

    private PsiElement getReferenceNameElement() {
        return this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
    }

    protected FtlReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            FtlReferenceExpression.$$$reportNull$$$0(0);
        }
        super(node);
        this.myReference = new FtlQualifiedReference(this){

            public TextRange getRangeInElement() {
                PsiElement element = FtlReferenceExpression.this.getReferenceNameElement();
                if (element == null || FtlReferenceExpression.this.isSpecialVariable()) {
                    return TextRange.from((int)0, (int)FtlReferenceExpression.this.getTextLength());
                }
                return TextRange.from((int)element.getStartOffsetInParent(), (int)element.getTextLength());
            }

            @Override
            @Nullable
            public String getReferenceName() {
                PsiElement element = FtlReferenceExpression.this.getReferenceNameElement();
                if (element == null) {
                    return null;
                }
                String s = element.getText().trim();
                return FtlReferenceExpression.this.isSpecialVariable() ? "." + s : s;
            }

            @Override
            public FtlReferenceQualifier getReferenceQualifier() {
                return (FtlReferenceQualifier)FtlReferenceExpression.this.findChildByClass(FtlReferenceQualifier.class);
            }

            @Override
            public PsiElement doHandleElementRename(String newElementName) throws IncorrectOperationException {
                LeafElement newReferenceName = ASTFactory.leaf((IElementType)FtlElementTypes.IDENTIFIER, (CharSequence)newElementName);
                CodeEditUtil.setNodeGenerated((ASTNode)newReferenceName, (boolean)true);
                FtlReferenceExpression.this.getNode().replaceChild(FtlReferenceExpression.this.getReferenceNameElement().getNode(), (ASTNode)newReferenceName);
                return FtlReferenceExpression.this;
            }
        };
    }

    @NotNull
    public FtlQualifiedReference getReference() {
        FtlQualifiedReference ftlQualifiedReference = this.myReference;
        if (ftlQualifiedReference == null) {
            FtlReferenceExpression.$$$reportNull$$$0(1);
        }
        return ftlQualifiedReference;
    }

    public boolean isSpecialVariable() {
        return this.getFirstChild().getNode().getElementType() == FtlElementTypes.DOT;
    }

    @Override
    @Nullable
    public FtlType getType() {
        return (FtlType)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, () -> this.myReference.getType());
    }

    @Override
    public Object getConstantValue() {
        return null;
    }

    @Override
    public FtlCallableType[] getCallableCandidates() {
        return this.myReference.getCallableCandidates();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/FtlReferenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/FtlReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

