/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.freemarker.editorActions.FreeMarkerBackspaceHandler;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlLanguage;
import com.intellij.freemarker.psi.FtlLiteralExpression;
import com.intellij.freemarker.psi.FtlSequenceLiteral;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class FreeMarkerTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        FileViewProvider viewProvider = file.getViewProvider();
        if (!file.getViewProvider().getBaseLanguage().isKindOf((Language)FtlLanguage.INSTANCE)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        int offset = caretOffset;
        if (offset == 0) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == ']' || c == '>') {
            char startChar;
            FtlSequenceLiteral literal;
            CharSequence sequence = document.getCharsSequence();
            if (sequence.charAt(offset - 1) == '/') {
                return TypedHandlerDelegate.Result.DEFAULT;
            }
            documentManager.commitDocument(document);
            while (offset > 0 && (offset >= sequence.length() || sequence.charAt(offset) == ' ')) {
                --offset;
            }
            FtlXmlTag tag = (FtlXmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), FtlXmlTag.class, (boolean)false);
            if (tag == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            PsiElement leaf = tag.getContainingFile().findElementAt(offset);
            if (leaf == null || leaf.getContainingFile() != viewProvider.getPsi(viewProvider.getBaseLanguage())) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (leaf instanceof PsiComment) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (c == ']' && !tag.isOpeningTagClosed() && (literal = (FtlSequenceLiteral)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), FtlSequenceLiteral.class, (boolean)false)) != null && FtlDirectiveStyle.SQUARE == literal.getContainingFtlFile().getDirectiveStyle()) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"]", (boolean)true);
                return TypedHandlerDelegate.Result.STOP;
            }
            if (tag.isClosed()) {
                return TypedHandlerDelegate.Result.DEFAULT;
            }
            if (!tag.needsClosing()) {
                return TypedHandlerDelegate.Result.DEFAULT;
            }
            if (c == ']' && leaf.getParent() instanceof FtlIndexExpression) {
                return TypedHandlerDelegate.Result.DEFAULT;
            }
            char c2 = startChar = c == ']' ? (char)'[' : '<';
            if (!tag.getFirstChild().getText().startsWith(String.valueOf(startChar))) {
                return TypedHandlerDelegate.Result.DEFAULT;
            }
            IElementType elementType = leaf.getNode().getElementType();
            if (elementType == FtlElementTypes.TEMPLATE_TEXT || elementType == FtlElementTypes.STRING_TEXT || elementType == FtlElementTypes.CHAR_ESCAPE) {
                return TypedHandlerDelegate.Result.DEFAULT;
            }
            String name = tag.getDirectiveTagName();
            if (name.length() >= 2 && name.charAt(0) == '@' && !Character.isJavaIdentifierStart(name.charAt(1))) {
                name = "@";
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(String.valueOf(c) + startChar + "/" + name + c), (boolean)true, (int)1);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == '}' && TypedHandler.handleRParen((Editor)editor, (FileType)fileType, (char)c)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == '\'' || c == '\"') {
            CharSequence sequence = document.getCharsSequence();
            if (sequence.length() <= offset) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            char next = sequence.charAt(offset);
            if (Character.isJavaIdentifierPart(next)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(c));
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        char c;
        int offset;
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (!file.getViewProvider().getBaseLanguage().isKindOf((Language)FtlLanguage.INSTANCE)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (charTyped == '#' && (offset = editor.getCaretModel().getOffset()) > 0 && (FreeMarkerTypedHandler.isDirectiveStart(c = document.getCharsSequence().charAt(offset - 1)) || c == '/' && offset > 1 && FreeMarkerTypedHandler.isDirectiveStart(document.getCharsSequence().charAt(offset - 2)))) {
            documentManager.commitDocument(document);
            PsiElement element = file.findElementAt(offset - 1);
            if (element != null && element.getTextLength() <= 2) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean isDirectiveStart(char c) {
        return c == '[' || c == '<';
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (!file.getViewProvider().getBaseLanguage().isKindOf((Language)FtlLanguage.INSTANCE)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '/') {
            documentManager.commitDocument(document);
            FtlXmlTag tag = (FtlXmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), FtlXmlTag.class, (boolean)false);
            if (tag == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            return TypedHandlerDelegate.Result.DEFAULT;
        }
        if (c == '[') {
            FtlXmlTag grandParent;
            char nextChar;
            if (offset < document.getTextLength() && (Character.isJavaIdentifierPart(nextChar = document.getCharsSequence().charAt(offset)) || FreeMarkerTypedHandler.isBeforeLiteral(file, offset, nextChar))) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            documentManager.commitDocument(document);
            PsiElement element = file.findElementAt(offset - 1);
            if (FreeMarkerBackspaceHandler.needsRightBracket(element) && (grandParent = (FtlXmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, FtlXmlTag.class)) != null && !grandParent.isOpeningTagClosed()) {
                document.insertString(offset, (CharSequence)"]");
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean isBeforeLiteral(PsiFile file, int offset, char nextChar) {
        if ('\"' != nextChar && '\'' != nextChar) {
            return false;
        }
        return offset >= 2 && PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 2), FtlLiteralExpression.class, (boolean)false) == null && PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, FtlLiteralExpression.class, (boolean)false) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/freemarker/editorActions/FreeMarkerTypedHandler";
        objectArray[2] = "charTyped";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

