/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.StreamGobbler;

public final class ExecResult {
    private int myExitCode = -1;
    private String myStdout = "";
    private String myStderr = "";
    private StreamGobbler myOutputGobbler;
    private StreamGobbler myErrorGobbler;
    private Throwable myException = null;
    private String myErrorString;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ErrCode=");
        buf.append(this.getExitCode());
        buf.append("\nStdOut:------------\n");
        ExecResult.appendStreamData(this.myStdout, this.myOutputGobbler, buf);
        buf.append("\nStdErr:------------\n");
        ExecResult.appendStreamData(this.myStderr, this.myErrorGobbler, buf);
        if (this.getException() != null) {
            buf.append("\nException----------\n");
            buf.append(this.getException());
        }
        buf.append("\nEnd----------------\n");
        return buf.toString();
    }

    private static void appendStreamData(String data, StreamGobbler gobbler, StringBuilder buf) {
        if (gobbler != null) {
            buf.append(gobbler.toString());
        } else {
            buf.append(data);
        }
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void setStdout(String stdout) {
        this.myStdout = stdout;
    }

    public void setStderr(String stderr) {
        this.myStderr = stderr;
    }

    public void allowSafeStdoutUsage(ThrowableConsumer<InputStream, IOException> consumer) throws IOException {
        if (this.myOutputGobbler != null) {
            this.myOutputGobbler.allowSafeStreamUsage(consumer);
        } else {
            consumer.consume((Object)new ByteArrayInputStream(this.myStdout.getBytes()));
        }
    }

    @NotNull
    public String getStdout() {
        if (this.myOutputGobbler != null) {
            String string = ExecResult.readStreamConvertingLineSeparators(this.myOutputGobbler);
            if (string == null) {
                ExecResult.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = this.myStdout;
        if (string == null) {
            ExecResult.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setOutputGobbler(StreamGobbler outputGobbler) {
        this.myOutputGobbler = outputGobbler;
    }

    public void setErrorGobbler(StreamGobbler errorGobbler) {
        this.myErrorGobbler = errorGobbler;
    }

    @NotNull
    public String getStderr() {
        if (this.myErrorGobbler != null) {
            if (this.myErrorString == null) {
                this.myErrorString = ExecResult.readStreamConvertingLineSeparators(this.myErrorGobbler);
            }
            String string = this.myErrorString;
            if (string == null) {
                ExecResult.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.myStderr;
        if (string == null) {
            ExecResult.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Throwable getException() {
        return this.myException;
    }

    public void setException(Throwable exception) {
        this.myException = exception;
    }

    private static String readStreamConvertingLineSeparators(StreamGobbler gobbler) {
        try {
            StringBuilder result = new StringBuilder(gobbler.getResultLength());
            gobbler.allowSafeStreamUsage((ThrowableConsumer<InputStream, IOException>)((ThrowableConsumer)inputStream -> {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                ExecResult.appendDataConvertingLineSeparators(reader, result);
            }));
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendDataConvertingLineSeparators(BufferedReader reader, StringBuilder result) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            result.append(line);
            result.append('\n');
        }
    }

    public long getOutSize() {
        if (this.myOutputGobbler != null) {
            return this.myOutputGobbler.getResultLength();
        }
        return 0L;
    }

    public byte[] getByteOut() {
        Ref ref = new Ref();
        if (this.myOutputGobbler != null) {
            try {
                this.myOutputGobbler.allowSafeStreamUsage((ThrowableConsumer<InputStream, IOException>)((ThrowableConsumer)inputStream -> ref.set((Object)FileUtil.loadBytes((InputStream)inputStream, (int)this.myOutputGobbler.getResultLength()))));
                return (byte[])ref.get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public void cleanup() {
        if (this.myOutputGobbler != null) {
            this.myOutputGobbler.deleteTempFile();
        }
        if (this.myErrorGobbler != null) {
            this.myErrorGobbler.deleteTempFile();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/perforce/perforce/ExecResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdout";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderr";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

