/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.facet;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.FrameworkSupportWithLibrary;
import com.intellij.hibernate.HibernateMessages;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateFacetType;
import com.intellij.hibernate.facet.HibernateLibraryType;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.jpa.facet.JpaFrameworkSupportProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateFrameworkSupportProvider
extends FacetBasedFrameworkSupportProvider<HibernateFacet> {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.hibernate.facet.HibernateFrameworkSupportProvider");

    protected HibernateFrameworkSupportProvider() {
        super((FacetType)HibernateFacetType.getInstance());
    }

    public String getTitle() {
        return HibernateMessages.message("framework.title.hibernate", new Object[0]);
    }

    protected void setupConfiguration(HibernateFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            HibernateFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        HibernateConfigurable hibernateConfigurable = new HibernateConfigurable(model);
        if (hibernateConfigurable == null) {
            HibernateFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return hibernateConfigurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/facet/HibernateFrameworkSupportProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/facet/HibernateFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HibernateConfigurable
    extends FrameworkSupportConfigurableBase
    implements FrameworkSupportWithLibrary {
        private JPanel myPanel;
        private JCheckBox myCreateMainClass;
        private JCheckBox myDbImport;

        public HibernateConfigurable(FrameworkSupportModel model) {
            super((FrameworkSupportProviderBase)HibernateFrameworkSupportProvider.this, model, HibernateFrameworkSupportProvider.this.getVersions(), null);
        }

        public JComponent getComponent() {
            if (this.myPanel == null) {
                this.myPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
                JComponent superC = super.getComponent();
                if (superC != null) {
                    this.myPanel.add(superC);
                }
                this.myCreateMainClass = new JCheckBox(HibernateMessages.message("framework.configurable.generate.main.and.config", new Object[0]));
                this.myDbImport = new JCheckBox(HibernateMessages.message("framework.configurable.import.database", new Object[0]));
                this.myPanel.add(this.myCreateMainClass);
                this.myPanel.add(this.myDbImport);
            }
            return this.myPanel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
            if (module == null) {
                HibernateConfigurable.$$$reportNull$$$0(0);
            }
            if (rootModel == null) {
                HibernateConfigurable.$$$reportNull$$$0(1);
            }
            super.addSupport(module, rootModel, library);
            HibernateFacet facet = (HibernateFacet)FacetManager.getInstance((Module)module).getFacetByType(HibernateFacet.ID);
            assert (facet != null);
            boolean isCreateMain = this.myCreateMainClass.isSelected();
            boolean isDbImport = this.myDbImport.isSelected();
            Runnable runnable = () -> {
                if (module == null) {
                    HibernateConfigurable.$$$reportNull$$$0(5);
                }
                try {
                    VirtualFile[] sourceRoots;
                    if ((isCreateMain || isDbImport) && !PackageUtil.checkSourceRootsConfigured((Module)module)) {
                        return;
                    }
                    if (isCreateMain && (sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots()).length > 0) {
                        PsiDirectory directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(sourceRoots[0]);
                        String fileName = HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA.getFileName();
                        if (directory != null) {
                            PsiFile configElement = directory.findFile(fileName);
                            if (configElement == null) {
                                FileTemplate configTemplate = FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate(this.getTemplateName(HibernateUtil.getHibernateVersion(module)));
                                configElement = FileTemplateUtil.createFromTemplate((FileTemplate)configTemplate, (String)fileName, null, (PsiDirectory)directory);
                            }
                            if (configElement instanceof XmlFile) {
                                XmlFile xmlFile = (XmlFile)configElement;
                                String url = xmlFile.getVirtualFile().getUrl();
                                facet.getDescriptorsContainer().getConfiguration().addConfigFile(HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA, url);
                            }
                            String mainFileName = "Main.java";
                            PsiFile mainElement = directory.findFile("Main.java");
                            if (mainElement == null) {
                                FileTemplate mainTemplate = FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate(this.getMainTemplateName(HibernateUtil.getHibernateVersion(module)));
                                mainElement = FileTemplateUtil.createFromTemplate((FileTemplate)mainTemplate, (String)"Main.java", null, (PsiDirectory)directory);
                            }
                            if (mainElement instanceof PsiFile) {
                                PsiFile psiFile = mainElement;
                            }
                        }
                    }
                    if (isDbImport) {
                        JpaFrameworkSupportProvider.scheduleDbImport((Module)module, (PersistenceFacet)facet);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            };
            JpaFrameworkSupportProvider.scheduleRunnable((Module)module, (Runnable)runnable);
        }

        private String getMainTemplateName(HibernateVersion version) {
            return version.getMainTemplateName();
        }

        @NotNull
        private String getTemplateName(HibernateVersion version) {
            for (ConfigFileVersion configFileVersion : HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA.getVersions()) {
                if (!configFileVersion.getName().equals(version.getName())) continue;
                String string = configFileVersion.getTemplateName();
                if (string == null) {
                    HibernateConfigurable.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA.getDefaultVersion().getTemplateName();
            if (string == null) {
                HibernateConfigurable.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public CustomLibraryDescription createLibraryDescription() {
            CustomLibraryDescription customLibraryDescription = DownloadableLibraryService.getInstance().createDescriptionForType(HibernateLibraryType.class);
            if (customLibraryDescription == null) {
                HibernateConfigurable.$$$reportNull$$$0(4);
            }
            return customLibraryDescription;
        }

        public boolean isLibraryOnly() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootModel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/hibernate/facet/HibernateFrameworkSupportProvider$HibernateConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/hibernate/facet/HibernateFrameworkSupportProvider$HibernateConfigurable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplateName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibraryDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addSupport";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addSupport$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

