/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.engine;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.hibernate.engine.HibernateConnectionManager;
import com.intellij.hibernate.engine.HibernateEngine;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackagePointer;
import icons.HibernateCoreIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConsole
extends JpaConsoleBase {
    public static final String CONSOLE_TOOLWINDOW_ID = "Hibernate Console";

    @NotNull
    public static JpaConsoleBase.Builder<HibernateConsole> newConsole(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            HibernateConsole.$$$reportNull$$$0(0);
        }
        JpaConsoleBase.Builder<HibernateConsole> builder = new JpaConsoleBase.Builder<HibernateConsole>(unitFile){

            public HibernateConsole build() {
                SimpleRequestBroker broker = SimpleRequestBroker.newInstance((Project)this.getProject(), (String)this.myUnitFile.getElementName());
                HibernateConsole console = new HibernateConsole(this.myUnitFile, this.myConfiguration, (DataBus.Consuming)broker, this.myQuery);
                HibernateEngine engine = new HibernateEngine((DataBus.Producing)broker, this.myUnitFile, this.myConfiguration);
                Disposer.register((Disposable)console, (Disposable)engine);
                return console;
            }
        };
        if (builder == null) {
            HibernateConsole.$$$reportNull$$$0(1);
        }
        return builder;
    }

    public HibernateConsole(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration, @NotNull DataBus.Consuming messageBus, @Nullable String query) {
        if (unitFile == null) {
            HibernateConsole.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            HibernateConsole.$$$reportNull$$$0(3);
        }
        if (messageBus == null) {
            HibernateConsole.$$$reportNull$$$0(4);
        }
        super(unitFile, configuration, messageBus, "hql", HibernateConsole.getInitialLanguage(unitFile.getPersistenceFacet()), query);
        this.getLanguageConsole().setPrompt("hql> ");
        this.getMessageBus().addAuditor((DataAuditor)new DataAuditor.Adapter(){

            public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable throwable) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context.request.owner != HibernateConsole.this || throwable == null) {
                    return;
                }
                if (StringUtil.getThrowableText((Throwable)throwable).contains("org.hibernate.") || throwable instanceof IllegalStateException || throwable instanceof ClassNotFoundException) {
                    super.error(context, message, throwable);
                } else {
                    AbstractQueryLanguageConsole.LOG.error(throwable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/hibernate/engine/HibernateConsole$2", "error"));
            }
        });
    }

    public static List<HibernateConsole> getActiveConsoles(Project project) {
        return AbstractQueryLanguageConsole.getActiveConsoles((Project)project, (String)CONSOLE_TOOLWINDOW_ID);
    }

    private static Language getInitialLanguage(PersistenceFacet facet) {
        Language qlLanguage = facet.getQlLanguage();
        return qlLanguage == null ? JpqlLanguage.JPQL : qlLanguage;
    }

    public String getToolWindowId() {
        return CONSOLE_TOOLWINDOW_ID;
    }

    public Icon getToolWindowIcon() {
        return HibernateCoreIcons.HibConsoleToolWindow;
    }

    protected String getHelpID() {
        return "tool.window.reference.hibernate.console";
    }

    public boolean isStarted() {
        return HibernateConnectionManager.getInstance(this.getProject()).getActiveConfigurations((PersistencePackagePointer)this.getTarget()).contains(this.getConfiguration());
    }

    public void terminate() {
        HibernateConnectionManager.getInstance(this.getProject()).releaseConnection((PersistencePackagePointer)this.getTarget(), this.getConfiguration());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/engine/HibernateConsole";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/engine/HibernateConsole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsole";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

