/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.nashorn.NashornJSBreakpointHandler;
import com.intellij.javascript.debugger.nashorn.NashornJSBreakpointHandlerFactory;
import com.intellij.javascript.debugger.nashorn.NashornSourceMapHandler;
import com.intellij.javascript.debugger.nashorn.NashornSourceMapHandlerKt;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapCollector;
import com.intellij.javascript.debugger.sourcemap.SourceMapDecoder;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugSession;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornJSBreakpointHandlerFactory;", "Lcom/intellij/debugger/engine/JavaBreakpointHandlerFactory;", "()V", "createHandler", "Lcom/intellij/debugger/engine/JavaBreakpointHandler;", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "nashorn-debugger"})
public final class NashornJSBreakpointHandlerFactory
implements JavaBreakpointHandlerFactory {
    @NotNull
    public JavaBreakpointHandler createHandler(@NotNull DebugProcessImpl process) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
        if (Intrinsics.areEqual((Object)JSRootConfiguration.getInstance((Project)process.getProject()).getLanguageLevel(), (Object)JSLanguageLevel.NASHORN)) {
            process.putUserData(NashornSourceMapHandlerKt.getNASHORN_SOURCE_MAP_HANDLER_KEY(), (Object)LazyKt.lazy((Function0)((Function0)new Function0<NashornSourceMapHandler>(process){
                final /* synthetic */ DebugProcessImpl $process;

                @Nullable
                public final NashornSourceMapHandler invoke() {
                    try {
                        PreloadedSourceMapList list = new PreloadedSourceMapList();
                        XDebugSession xDebugSession = this.$process.getSession().getXDebugSession();
                        SourceMapCollector sourceMapCollector2 = new SourceMapCollector(list, new SourceMapDecoder(this){
                            final /* synthetic */ createHandler.1 this$0;

                            @Nullable
                            public SourceMap decodeSourceMap(@NotNull CharSequence sourceMapData, @NotNull Url baseUrl, boolean baseUrlIsFile) {
                                Intrinsics.checkParameterIsNotNull((Object)sourceMapData, (String)"sourceMapData");
                                Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
                                return SourceMapDecoderKt.decodeSourceMap((CharSequence)sourceMapData, (Function2)((Function2)new Function2<List<? extends String>, List<? extends String>, SourceResolver>(this, baseUrl){
                                    final /* synthetic */ createHandler.sourceMapCollector.1 this$0;
                                    final /* synthetic */ Url $baseUrl;

                                    @NotNull
                                    public final SourceResolver invoke(@NotNull List<String> sourceUrls, @Nullable List<String> sourceContents) {
                                        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
                                        Project project = this.this$0.this$0.$process.getProject();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"process.project");
                                        return FileResolverByContentKt.createJSSourceResolver(sourceUrls, (Url)this.$baseUrl, (boolean)true, (boolean)true, (boolean)true, (Project)project, sourceContents);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$baseUrl = url;
                                        super(2);
                                    }
                                }));
                            }
                            {
                                this.this$0 = $outer;
                            }
                        }, xDebugSession);
                        Path basePath = Paths.get(VfsUtil.toUri((VirtualFile)this.$process.getProject().getBaseDir()));
                        Url baseUrl = Urls.newLocalFileUrl((VirtualFile)this.$process.getProject().getBaseDir());
                        Path path = basePath;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"basePath");
                        Url url = baseUrl;
                        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"baseUrl");
                        SourceMapCollector.resolveSourcemaps$default((SourceMapCollector)sourceMapCollector2, (Path)path, (Url)url, null, (boolean)false, (boolean)false, (int)0, (int)60, null);
                        Project project = this.$process.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"process.project");
                        return new NashornSourceMapHandler(project, list);
                    }
                    catch (Exception e) {
                        Logger logger = Logger.getInstance(NashornJSBreakpointHandlerFactory.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.error((Throwable)e);
                        return null;
                    }
                }
                {
                    this.$process = debugProcessImpl;
                    super(0);
                }
            })));
        }
        return new NashornJSBreakpointHandler(process);
    }
}

