/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceFileRevision
implements VcsFileRevision {
    private final P4Revision myP4Revision;
    private final PerforceVcsRevisionNumber myNumber;
    private final Project myProject;
    private final P4Connection myConnection;

    public PerforceFileRevision(@NotNull P4Revision p4Revision, @NotNull P4Connection connection, @NotNull Project project) {
        if (p4Revision == null) {
            PerforceFileRevision.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            PerforceFileRevision.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PerforceFileRevision.$$$reportNull$$$0(2);
        }
        this.myP4Revision = p4Revision;
        this.myProject = project;
        this.myNumber = new PerforceVcsRevisionNumber(this.myP4Revision);
        this.myConnection = connection;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        PerforceVcsRevisionNumber perforceVcsRevisionNumber = this.myNumber;
        if (perforceVcsRevisionNumber == null) {
            PerforceFileRevision.$$$reportNull$$$0(3);
        }
        return perforceVcsRevisionNumber;
    }

    public Date getRevisionDate() {
        return this.myP4Revision.getDate();
    }

    public String getAuthor() {
        return this.myP4Revision.getUser();
    }

    public String getCommitMessage() {
        return this.myP4Revision.getSubmitMessage();
    }

    public byte[] loadContent() throws IOException, VcsException {
        return PerforceRunner.getInstance(this.myProject).getByteContent(this.myP4Revision.getDepotPath(), "#" + this.myP4Revision.getRevisionNumber(), this.myConnection);
    }

    public byte[] getContent() throws IOException, VcsException {
        return ContentRevisionCache.getOrLoadAsBytes((Project)this.myProject, (FilePath)VcsContextFactory.SERVICE.getInstance().createFilePathOnNonLocal(this.myP4Revision.getDepotPath(), false), (VcsRevisionNumber)this.myNumber, (VcsKey)PerforceVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REMOTE_CONTENT, () -> this.loadContent());
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public long getVersionNumber() {
        return this.myP4Revision.getRevisionNumber();
    }

    public String getAction() {
        return this.myP4Revision.getAction();
    }

    public String getClient() {
        return this.myP4Revision.getClient();
    }

    public String getBranchName() {
        return null;
    }

    @NotNull
    public P4Connection getConnection() {
        P4Connection p4Connection = this.myConnection;
        if (p4Connection == null) {
            PerforceFileRevision.$$$reportNull$$$0(4);
        }
        return p4Connection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p4Revision";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceFileRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceFileRevision";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

