/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ChangeCreator;
import org.jetbrains.idea.perforce.application.LocalPathsSet;
import org.jetbrains.idea.perforce.application.PerforceChangeListCalculator;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.ResolvedFilesWrapper;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.ResolvedFile;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class OpenedResultProcessor {
    public static final Key<Boolean> BRANCHED_FILE = Key.create((String)"Perforce.branched.file");
    private final ChangelistBuilder myBuilder;
    private final P4Connection myConnection;
    private final ChangeCreator myChangeCreator;
    private final LocalPathsSet myResolvedWithConflicts;
    private final ResolvedFilesWrapper myResolvedFiles;
    private final PerforceChangeListCalculator myChangelistCalculator;
    private final LocalFileSystem myLocalFileSystem;

    public OpenedResultProcessor(@NotNull P4Connection connection, ChangeCreator changeCreator, ChangelistBuilder builder, LocalPathsSet resolvedWithConflicts, ResolvedFilesWrapper resolvedFiles, PerforceChangeListCalculator changelistCalculator) {
        if (connection == null) {
            OpenedResultProcessor.$$$reportNull$$$0(0);
        }
        this.myConnection = connection;
        this.myChangeCreator = changeCreator;
        this.myBuilder = builder;
        this.myResolvedWithConflicts = resolvedWithConflicts;
        this.myResolvedFiles = resolvedFiles;
        this.myChangelistCalculator = changelistCalculator;
        this.myLocalFileSystem = LocalFileSystem.getInstance();
    }

    @NotNull
    private static FilePath toCanonicalFilePath(File file) {
        VirtualFile vFile;
        if (!SystemInfo.isFileSystemCaseSensitive && (vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false)) != null) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)vFile);
            if (filePath == null) {
                OpenedResultProcessor.$$$reportNull$$$0(1);
            }
            return filePath;
        }
        FilePath filePath = VcsUtil.getFilePath((File)file);
        if (filePath == null) {
            OpenedResultProcessor.$$$reportNull$$$0(2);
        }
        return filePath;
    }

    public void process(Collection<PerforceChange> p4changes) throws VcsException {
        this.clearBranchedFlag(p4changes);
        LinkedList<MyAbstractProcessor> processors = new LinkedList<MyAbstractProcessor>();
        processors.add(new MyLocallyDeletedProcessor());
        MyDeletedProcessor deletedProcessor = new MyDeletedProcessor();
        processors.add(deletedProcessor);
        MyAddedProcessor addedProcessor = new MyAddedProcessor(deletedProcessor);
        processors.add(addedProcessor);
        processors.add(new MyBranchedProcessor());
        processors.add(new MyEditedProcessor());
        for (MyAbstractProcessor processor : processors) {
            processor.processList(p4changes);
        }
        deletedProcessor.postProcessAll();
    }

    private void clearBranchedFlag(Collection<PerforceChange> p4changes) {
        for (PerforceChange change : p4changes) {
            File ioFile = change.getFile();
            if (ioFile == null) continue;
            VirtualFile file = this.myLocalFileSystem.findFileByIoFile(ioFile);
            if (file == null && ioFile.exists()) {
                file = this.myLocalFileSystem.refreshAndFindFileByIoFile(ioFile);
            }
            if (file == null) continue;
            file.putUserData(BRANCHED_FILE, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/OpenedResultProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/OpenedResultProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditedProcessor
    extends MyAbstractProcessor {
        private MyEditedProcessor() {
            super(true);
        }

        @Override
        protected boolean matches(PerforceChange perforceChange) {
            return perforceChange.getRevision() > 0L && (perforceChange.getType() == 2 || perforceChange.getType() == 4);
        }

        @Override
        protected void process(PerforceChange perforceChange, ChangeList changeList) {
            File file = perforceChange.getFile();
            if (file == null) {
                return;
            }
            OpenedResultProcessor.this.myBuilder.processChangeInList(OpenedResultProcessor.this.myChangeCreator.createEditedFileChange(OpenedResultProcessor.toCanonicalFilePath(file), perforceChange.getRevision(), OpenedResultProcessor.this.myResolvedWithConflicts.contains(file)), changeList, PerforceVcs.getKey());
        }
    }

    private class MyBranchedProcessor
    extends MyAbstractProcessor {
        private MyBranchedProcessor() {
            super(true);
        }

        @Override
        protected boolean matches(PerforceChange perforceChange) {
            return perforceChange.getType() == 3;
        }

        @Override
        protected void process(PerforceChange perforceChange, ChangeList changeList) {
            File file = perforceChange.getFile();
            if (file == null) {
                return;
            }
            FilePath filePath = OpenedResultProcessor.toCanonicalFilePath(file);
            OpenedResultProcessor.this.myBuilder.processChangeInList(OpenedResultProcessor.this.myChangeCreator.createAddedFileChange(filePath, OpenedResultProcessor.this.myResolvedWithConflicts.contains(file)), changeList, PerforceVcs.getKey());
            VirtualFile vf = filePath.getVirtualFile();
            if (vf == null) {
                vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath.getPath());
            }
            if (vf != null) {
                vf.putUserData(BRANCHED_FILE, (Object)Boolean.TRUE);
            }
        }
    }

    private class MyAddedProcessor
    extends MyAbstractProcessor {
        private final MyDeletedProcessor myDeletedProcessor;

        private MyAddedProcessor(MyDeletedProcessor deletedProcessor) {
            super(true);
            this.myDeletedProcessor = deletedProcessor;
        }

        @Override
        protected boolean matches(PerforceChange perforceChange) {
            int type = perforceChange.getType();
            return type == 0 || type == 5;
        }

        @Override
        protected void process(PerforceChange perforceChange, ChangeList changeList) {
            PerforceChange deletedChange;
            String operation;
            ResolvedFile resolvedPeer;
            File file = perforceChange.getFile();
            ResolvedFile resolvedFile = resolvedPeer = file == null ? null : OpenedResultProcessor.this.myResolvedFiles.getLocalToFiles().get(file);
            if (resolvedPeer != null && ("branch from".equals(operation = resolvedPeer.getOperation()) || "moved from".equals(operation)) && (deletedChange = this.myDeletedProcessor.removePeer(resolvedPeer.getDepotPath())) != null) {
                OpenedResultProcessor.this.myBuilder.processChangeInList(OpenedResultProcessor.this.myChangeCreator.createRenameChange(OpenedResultProcessor.this.myConnection, resolvedPeer, OpenedResultProcessor.toCanonicalFilePath(file)), changeList, PerforceVcs.getKey());
                return;
            }
            OpenedResultProcessor.this.myBuilder.processChangeInList(OpenedResultProcessor.this.myChangeCreator.createAddedFileChange(OpenedResultProcessor.toCanonicalFilePath(file), OpenedResultProcessor.this.myResolvedWithConflicts.contains(file)), changeList, PerforceVcs.getKey());
        }
    }

    private class MyDeletedProcessor
    extends MyAbstractProcessor {
        private final Map<String, PerforceChange> myDeleted;

        private MyDeletedProcessor() {
            super(true);
            this.myDeleted = new HashMap<String, PerforceChange>();
        }

        @Override
        protected boolean matches(PerforceChange perforceChange) {
            int type = perforceChange.getType();
            return type == 1 || type == 6;
        }

        @Override
        protected void process(PerforceChange perforceChange, ChangeList changeList) {
            if (OpenedResultProcessor.this.myResolvedFiles.getDepotToFiles().containsKey(perforceChange.getDepotPath())) {
                this.myDeleted.put(perforceChange.getDepotPath(), perforceChange);
                return;
            }
            File file = perforceChange.getFile();
            if (file == null) {
                return;
            }
            OpenedResultProcessor.this.myBuilder.processChangeInList(OpenedResultProcessor.this.myChangeCreator.createDeletedFileChange(file, perforceChange.getRevision(), false), changeList, PerforceVcs.getKey());
        }

        public void postProcessAll() throws VcsException {
            for (PerforceChange perforceChange : this.myDeleted.values()) {
                ChangeList changeList = OpenedResultProcessor.this.myChangelistCalculator.convert(perforceChange);
                File file = perforceChange.getFile();
                if (file == null) {
                    return;
                }
                OpenedResultProcessor.this.myBuilder.processChangeInList(OpenedResultProcessor.this.myChangeCreator.createDeletedFileChange(file, perforceChange.getRevision(), false), changeList, PerforceVcs.getKey());
            }
        }

        public PerforceChange removePeer(String depotPath) {
            return this.myDeleted.remove(depotPath);
        }
    }

    private class MyLocallyDeletedProcessor
    extends MyAbstractProcessor {
        private MyLocallyDeletedProcessor() {
            super(true);
        }

        @Override
        protected boolean matches(PerforceChange perforceChange) {
            File file = perforceChange.getFile();
            int type = perforceChange.getType();
            return file != null && type != 1 && type != 6 && OpenedResultProcessor.this.myLocalFileSystem.findFileByIoFile(file) == null && !file.exists();
        }

        @Override
        protected void process(PerforceChange change, ChangeList changeList) {
            File file = change.getFile();
            if (file == null) {
                return;
            }
            if (change.getType() == 0 || change.getType() == 5) {
                OpenedResultProcessor.this.myBuilder.processChangeInList(OpenedResultProcessor.this.myChangeCreator.createAddedFileChange(OpenedResultProcessor.toCanonicalFilePath(file), true), changeList, PerforceVcs.getKey());
            }
            OpenedResultProcessor.this.myBuilder.processLocallyDeletedFile(VcsUtil.getFilePath((File)file, (boolean)false));
        }
    }

    private abstract class MyAbstractProcessor {
        private final boolean myRequireChangeList;

        protected MyAbstractProcessor(boolean requireChangeList) {
            this.myRequireChangeList = requireChangeList;
        }

        protected abstract boolean matches(PerforceChange var1);

        protected abstract void process(PerforceChange var1, ChangeList var2);

        public void processList(Collection<PerforceChange> perforceChanges) throws VcsException {
            Iterator<PerforceChange> iterator = perforceChanges.iterator();
            while (iterator.hasNext()) {
                PerforceChange change = iterator.next();
                if (change.getFile() == null || !this.matches(change)) continue;
                ChangeList changeList = this.myRequireChangeList ? OpenedResultProcessor.this.myChangelistCalculator.convert(change) : null;
                iterator.remove();
                this.process(change, changeList);
            }
        }
    }
}

