/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import icons.PerforceIcons;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ChangeListData;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceFileRevision;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.perforce.PerforceChangeCache;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ShowAllSubmittedFilesAction
extends AnAction
implements DumbAware {
    public ShowAllSubmittedFilesAction() {
        super(PerforceBundle.message((String)"action.text.show.all.submitted", (Object[])new Object[0]), null, PerforceIcons.AllRevisions);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(e.getData(VcsDataKeys.VCS_FILE_REVISION) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (revision != null) {
            PerforceFileRevision perfRevision = (PerforceFileRevision)revision;
            ShowAllSubmittedFilesAction.showAllSubmittedFiles(project, ((PerforceVcsRevisionNumber)perfRevision.getRevisionNumber()).getChangeNumber(), perfRevision.getCommitMessage(), perfRevision.getRevisionDate(), perfRevision.getAuthor(), perfRevision.getConnection());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void showAllSubmittedFiles(Project project, long number, String submitMessage, Date date, String user, @NotNull P4Connection p4Connection) {
        if (p4Connection == null) {
            ShowAllSubmittedFilesAction.$$$reportNull$$$0(0);
        }
        try {
            void connection;
            PerforceChangeList changeList = ShowAllSubmittedFilesAction.getSubmittedChangeList(project, number, submitMessage, date, user, (P4Connection)connection);
            if (changeList != null) {
                if (changeList.getChanges().size() > 300) {
                    Messages.showInfoMessage((String)PerforceBundle.message((String)"show.all.files.from.change.list.too.many.files.affected.error.message", (Object[])new Object[0]), (String)ShowAllSubmittedFilesAction.getTitle(number));
                } else {
                    AbstractVcsHelper.getInstance((Project)project).showChangesListBrowser((CommittedChangeList)changeList, ShowAllSubmittedFilesAction.getTitle(number));
                }
            }
        }
        catch (VcsException ex) {
            Messages.showErrorDialog((String)PerforceBundle.message((String)"message.text.cannot.show.revisions", (Object[])new Object[]{ex.getLocalizedMessage()}), (String)ShowAllSubmittedFilesAction.getTitle(number));
        }
    }

    @Nullable
    public static PerforceChangeList getSubmittedChangeList(Project project, long number, String submitMessage, Date date, String user, P4Connection connection) throws VcsException {
        ChangeListData data = new ChangeListData();
        data.NUMBER = number;
        data.USER = user;
        data.DATE = ChangeListData.DATE_FORMAT.format(date);
        data.DESCRIPTION = submitMessage;
        final PerforceChangeList changeList = new PerforceChangeList(data, project, connection, new PerforceChangeCache(project));
        boolean result = VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

            public void run() throws VcsException {
                changeList.getChanges();
            }
        }, (String)PerforceBundle.message((String)"show.all.files.from.change.list.searching.for.changed.files.progress.title", (Object[])new Object[0]), (boolean)true, (Project)project);
        return result ? changeList : null;
    }

    private static String getTitle(long changeListNumber) {
        return PerforceBundle.message((String)"dialog.title.show.all.revisions.in.changelist", (Object[])new Object[]{changeListNumber});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/actions/ShowAllSubmittedFilesAction", "showAllSubmittedFiles"));
    }
}

