/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.ActionWithTempFile;
import java.util.List;
import org.jetbrains.idea.perforce.CancelActionException;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.ActionBaseFile;
import org.jetbrains.idea.perforce.actions.MessageManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceRunnerI;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public final class ActionEdit
extends ActionBaseFile {
    @Override
    protected void performAction(VirtualFile vFile, Project project, boolean topLevel, boolean alone, List<VirtualFile> filesToPostProcess) throws CancelActionException, VcsException {
        if (ChangeListManager.getInstance((Project)project).isIgnoredFile(vFile)) {
            return;
        }
        final P4File p4File = P4File.create(vFile);
        final PerforceRunnerI runner = PerforceRunner.getInstance(project).getProxy();
        ActionEdit.log("Action edit on file: " + p4File.getLocalPath());
        if (vFile.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = (VirtualFile[])ApplicationManager.getApplication().runReadAction(() -> vFile.getChildren())) {
                this.performAction(child, project, false, alone && children.length == 1, filesToPostProcess);
            }
        } else {
            if (FileStatusManager.getInstance((Project)project).getStatus(vFile) == FileStatus.IGNORED) {
                return;
            }
            if (!PerforceSettings.getSettings((Project)project).ENABLED) {
                filesToPostProcess.add(vFile);
                return;
            }
            FStat p4FStat = p4File.getFstat(project, true);
            if (p4FStat.status == FStat.STATUS_NOT_IN_CLIENTSPEC || p4FStat.status == FStat.STATUS_UNKNOWN) {
                if (vFile.isWritable()) {
                    return;
                }
                if (alone) {
                    String msg = PerforceBundle.message((String)"error.message.file.not.under.any.clientspec", (Object[])new Object[]{p4File.getLocalPath()});
                    MessageManager.showMessageDialog(project, msg, PerforceBundle.message((String)"message.title.cannot.edit", (Object[])new Object[0]), Messages.getErrorIcon());
                } else {
                    String msg = PerforceBundle.message((String)"confirmation.text.file.not.under.any.clientspec.continue.checkout", (Object[])new Object[]{p4File.getLocalPath()});
                    int answer = MessageManager.showDialog(project, msg, PerforceBundle.message((String)"message.title.cannot.edit", (Object[])new Object[0]), YES_NO_OPTIONS, 1, Messages.getErrorIcon());
                    if (answer != 0) {
                        throw new CancelActionException();
                    }
                }
            } else if (p4FStat.status == FStat.STATUS_NOT_ADDED || p4FStat.status == FStat.STATUS_ONLY_LOCAL) {
                if (alone) {
                    MessageManager.showMessageDialog(project, PerforceBundle.message((String)"message.text.file.not.on.server", (Object[])new Object[]{p4File.getLocalPath()}), PerforceBundle.message((String)"message.title.cannot.edit", (Object[])new Object[0]), Messages.getErrorIcon());
                }
            } else if (p4FStat.status == FStat.STATUS_DELETED) {
                if (alone) {
                    MessageManager.showMessageDialog(project, PerforceBundle.message((String)"message.text.file.deleted.from.server", (Object[])new Object[]{p4File.getLocalPath()}), PerforceBundle.message((String)"message.title.cannot.edit", (Object[])new Object[0]), Messages.getErrorIcon());
                }
            } else if (p4FStat.status == FStat.STATUS_ONLY_ON_SERVER) {
                String msg = PerforceBundle.message((String)"confirmation.text.file.registered.as.only.on.server.replace.it", (Object[])new Object[]{p4File.getLocalPath(), p4FStat.depotFile});
                int answer = MessageManager.showDialog(project, msg, PerforceBundle.message((String)"confirmation.title.file.already.in.perforce", (Object[])new Object[0]), YES_NO_CANCELREST_OPTIONS, 1, Messages.getErrorIcon());
                if (answer != 1) {
                    if (answer == 2 || answer == -1) {
                        throw new CancelActionException();
                    }
                    new ActionWithTempFile(p4File.getLocalFile()){

                        protected void executeInternal() throws VcsException {
                            runner.revert(p4File, false);
                            runner.sync(p4File, false);
                            runner.edit(p4File);
                        }
                    }.execute();
                }
            } else if (p4FStat.local == FStat.LOCAL_DELETING) {
                String msg = PerforceBundle.message((String)"confirmation.text.file.marked.for.deletion.revert.and.replace", (Object[])new Object[]{p4File.getLocalPath(), p4FStat.depotFile});
                int answer = MessageManager.showDialog(project, msg, PerforceBundle.message((String)"confirmation.title.file.already.in.perforce", (Object[])new Object[0]), YES_NO_CANCELREST_OPTIONS, 1, Messages.getErrorIcon());
                if (answer != 1) {
                    if (answer == 2 || answer == -1) {
                        throw new CancelActionException();
                    }
                    new ActionWithTempFile(p4File.getLocalFile()){

                        protected void executeInternal() throws VcsException {
                            runner.revert(p4File, false);
                            runner.edit(p4File);
                        }
                    }.execute();
                }
            } else if (p4FStat.local != FStat.LOCAL_CHECKED_IN && p4FStat.local != FStat.LOCAL_INTEGRATING) {
                if (alone) {
                    String msg = PerforceBundle.message((String)"message.text.file.already.being.checked.out.or.added", (Object[])new Object[]{p4File.getLocalPath()});
                    MessageManager.showMessageDialog(project, msg, PerforceBundle.message((String)"message.title.no.reason.to.edit", (Object[])new Object[0]), Messages.getInformationIcon());
                }
            } else {
                filesToPostProcess.add(vFile);
            }
        }
    }

    @Override
    public void postProcessFiles(Project project, List<VirtualFile> filesToPostProcess) {
        VirtualFile[] fileArray = VfsUtil.toVirtualFileArray(filesToPostProcess);
        try {
            PerforceVcs.getInstance(project).getEditFileProvider().editFiles(fileArray);
        }
        catch (VcsException e) {
            AbstractVcsHelper.getInstance((Project)project).showError(e, "");
        }
    }
}

