/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.wrapper;

import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.wrapper.MethodCall;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceUtil {
    private static final String THREE_DOTS = "...";

    public static List<TraceElement> sortedByTime(@NotNull Collection<TraceElement> values) {
        if (values == null) {
            TraceUtil.$$$reportNull$$$0(0);
        }
        return values.stream().sorted(Comparator.comparing(TraceElement::getTime)).collect(Collectors.toList());
    }

    @Nullable
    public static Object extractKey(@NotNull TraceElement element) {
        Value value;
        if (element == null) {
            TraceUtil.$$$reportNull$$$0(1);
        }
        if (!((value = element.getValue()) instanceof PrimitiveValue)) {
            return value;
        }
        if (value instanceof IntegerValue) {
            return ((IntegerValue)value).value();
        }
        if (value instanceof DoubleValue) {
            return ((DoubleValue)value).value();
        }
        if (value instanceof LongValue) {
            return ((LongValue)value).value();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).value();
        }
        if (value instanceof ByteValue) {
            return ((ByteValue)value).value();
        }
        if (value instanceof CharValue) {
            return Character.valueOf(((CharValue)value).value());
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((FloatValue)value).value());
        }
        throw new RuntimeException("unknown primitive value: " + value.type().name());
    }

    @NotNull
    public static String formatWithArguments(@NotNull MethodCall call2) {
        if (call2 == null) {
            TraceUtil.$$$reportNull$$$0(2);
        }
        String string = call2.getName() + StreamEx.of(call2.getArguments()).map(x -> StringUtil.shortenTextWithEllipsis((String)x.getText().replaceAll("\\s", ""), (int)30, (int)5, (String)THREE_DOTS)).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        if (string == null) {
            TraceUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String formatQualifierExpression(@NotNull String expression, int maxLength) {
        if (expression == null) {
            TraceUtil.$$$reportNull$$$0(4);
        }
        if ((expression = expression.replaceAll("\\s", "").replaceAll(",", ", ")).length() < maxLength) {
            String string = expression;
            if (string == null) {
                TraceUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (expression.isEmpty()) {
            if ("qualifier" == null) {
                TraceUtil.$$$reportNull$$$0(6);
            }
            return "qualifier";
        }
        String string = StringUtil.shortenTextWithEllipsis((String)expression, (int)(maxLength - 8), (int)5, (String)THREE_DOTS);
        if (string == null) {
            TraceUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/wrapper/TraceUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/wrapper/TraceUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatWithArguments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatQualifierExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sortedByTime";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractKey";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatWithArguments";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatQualifierExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

