/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.clientProperties;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.util.JdomKt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ClientPropertiesManager", defaultStateAsResource=true)
public class ClientPropertiesManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ClientPropertiesManager.class);
    @NonNls
    private static final String ELEMENT_PROPERTIES = "properties";
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String COMPONENT_NAME = "ClientPropertiesManager";
    private static final NotNullLazyValue<ClientPropertiesManager> ourDefaultManager = new AtomicNotNullLazyValue<ClientPropertiesManager>(){

        @NotNull
        protected ClientPropertiesManager compute() {
            ClientPropertiesManager result = new ClientPropertiesManager();
            try {
                result.loadState(JdomKt.loadElement((InputStream)ClientPropertiesManager.class.getResourceAsStream("/ClientPropertiesManager.xml")));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            ClientPropertiesManager clientPropertiesManager = result;
            if (clientPropertiesManager == null) {
                1.$$$reportNull$$$0(0);
            }
            return clientPropertiesManager;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/clientProperties/ClientPropertiesManager$1", "compute"));
        }
    };
    private final Map<String, List<ClientProperty>> myPropertyMap = new TreeMap<String, List<ClientProperty>>();

    public static ClientPropertiesManager getInstance(@NotNull Project project) {
        if (project == null) {
            ClientPropertiesManager.$$$reportNull$$$0(0);
        }
        return (ClientPropertiesManager)ServiceManager.getService((Project)project, ClientPropertiesManager.class);
    }

    public ClientPropertiesManager() {
    }

    private ClientPropertiesManager(Map<String, List<ClientProperty>> propertyMap) {
        this();
        this.myPropertyMap.putAll(propertyMap);
    }

    public ClientPropertiesManager clone() {
        return new ClientPropertiesManager(this.myPropertyMap);
    }

    public void saveFrom(ClientPropertiesManager manager) {
        this.myPropertyMap.clear();
        this.myPropertyMap.putAll(manager.myPropertyMap);
    }

    public void loadState(Element state) {
        this.myPropertyMap.clear();
        for (Element propertiesElement : state.getChildren(ELEMENT_PROPERTIES)) {
            String aClass = propertiesElement.getAttributeValue(ATTRIBUTE_CLASS);
            ArrayList<ClientProperty> classProps = new ArrayList<ClientProperty>();
            for (Element propertyElement : propertiesElement.getChildren(ELEMENT_PROPERTY)) {
                String propName = propertyElement.getAttributeValue(ATTRIBUTE_NAME);
                String propClass = propertyElement.getAttributeValue(ATTRIBUTE_CLASS);
                classProps.add(new ClientProperty(propName, propClass));
            }
            this.myPropertyMap.put(aClass, classProps);
        }
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        if (this.equals(ourDefaultManager.getValue())) {
            return element;
        }
        for (Map.Entry<String, List<ClientProperty>> entry : this.myPropertyMap.entrySet()) {
            Element propertiesElement = new Element(ELEMENT_PROPERTIES);
            propertiesElement.setAttribute(ATTRIBUTE_CLASS, entry.getKey());
            for (ClientProperty prop : entry.getValue()) {
                Element propertyElement = new Element(ELEMENT_PROPERTY);
                propertyElement.setAttribute(ATTRIBUTE_NAME, prop.getName());
                propertyElement.setAttribute(ATTRIBUTE_CLASS, prop.getValueClass());
                propertiesElement.addContent(propertyElement);
            }
            element.addContent(propertiesElement);
        }
        return element;
    }

    public void addConfiguredProperty(Class selectedClass, ClientProperty enteredProperty) {
        List<ClientProperty> list = this.myPropertyMap.get(selectedClass.getName());
        if (list == null) {
            list = new ArrayList<ClientProperty>();
            this.myPropertyMap.put(selectedClass.getName(), list);
        }
        list.add(enteredProperty);
    }

    public void removeConfiguredProperty(Class selectedClass, String name) {
        List<ClientProperty> list = this.myPropertyMap.get(selectedClass.getName());
        if (list != null) {
            for (ClientProperty prop : list) {
                if (!prop.getName().equals(name)) continue;
                list.remove(prop);
                break;
            }
        }
    }

    public List<Class> getConfiguredClasses(@NotNull Project project) {
        if (project == null) {
            ClientPropertiesManager.$$$reportNull$$$0(1);
        }
        ArrayList<Class> result = new ArrayList<Class>();
        for (String className : this.myPropertyMap.keySet()) {
            try {
                result.add(Class.forName(className, true, LoaderFactory.getInstance(project).getProjectClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return result;
    }

    public void addClientPropertyClass(String className) {
        if (!this.myPropertyMap.containsKey(className)) {
            this.myPropertyMap.put(className, new ArrayList());
        }
    }

    public void removeClientPropertyClass(Class selectedClass) {
        this.myPropertyMap.remove(selectedClass.getName());
    }

    public List<ClientProperty> getConfiguredProperties(Class componentClass) {
        List<ClientProperty> list = this.myPropertyMap.get(componentClass.getName());
        if (list == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ClientProperty>(list);
    }

    @NotNull
    public List<ClientProperty> getClientProperties(Class componentClass) {
        ArrayList<ClientProperty> result = new ArrayList<ClientProperty>();
        while (!componentClass.getName().equals(Object.class.getName())) {
            List<ClientProperty> props = this.myPropertyMap.get(componentClass.getName());
            if (props != null) {
                result.addAll(props);
            }
            componentClass = componentClass.getSuperclass();
        }
        result.sort(null);
        ArrayList<ClientProperty> arrayList = result;
        if (arrayList == null) {
            ClientPropertiesManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClientPropertiesManager)) {
            return false;
        }
        ClientPropertiesManager rhs = (ClientPropertiesManager)obj;
        if (rhs.myPropertyMap.size() != this.myPropertyMap.size()) {
            return false;
        }
        for (Map.Entry<String, List<ClientProperty>> entry : this.myPropertyMap.entrySet()) {
            List<ClientProperty> rhsList = rhs.myPropertyMap.get(entry.getKey());
            if (rhsList == null || rhsList.size() != entry.getValue().size()) {
                return false;
            }
            for (ClientProperty prop : entry.getValue()) {
                if (rhsList.contains(prop)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/clientProperties/ClientPropertiesManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/clientProperties/ClientPropertiesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredClasses";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClientProperty
    implements Comparable {
        private final String myName;
        private final String myClass;

        public ClientProperty(String name, String aClass) {
            this.myName = name;
            this.myClass = aClass;
        }

        public String getName() {
            return this.myName;
        }

        public String getValueClass() {
            return this.myClass;
        }

        public int compareTo(Object o) {
            ClientProperty prop = (ClientProperty)o;
            return this.myName.compareTo(prop.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientProperty that = (ClientProperty)o;
            if (!this.myClass.equals(that.myClass)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myClass.hashCode();
            return result;
        }
    }
}

