/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.cacheBuilder.SimpleWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.UnexpectedFormElementException;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.util.Processor;
import org.jdom.input.JDOMParseException;

public class FormWordsScanner
extends SimpleWordsScanner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.binding.FormWordsScanner");

    public void processWords(CharSequence fileText, final Processor<WordOccurrence> processor) {
        super.processWords(fileText, processor);
        try {
            LwRootContainer container = Utils.getRootContainer((String)fileText.toString(), null);
            String className = container.getClassToBind();
            if (className != null) {
                FormWordsScanner.processClassAndPackagesNames(className, processor);
            }
            FormEditingUtil.iterate((IComponent)container, new FormEditingUtil.ComponentVisitor(){
                WordOccurrence occurence;

                public boolean visit(IComponent iComponent) {
                    String componentClassName = iComponent.getComponentClassName();
                    FormWordsScanner.processClassAndPackagesNames(componentClassName, (Processor<WordOccurrence>)processor);
                    String binding = iComponent.getBinding();
                    if (binding != null) {
                        if (this.occurence == null) {
                            this.occurence = new WordOccurrence((CharSequence)binding, 0, binding.length(), WordOccurrence.Kind.FOREIGN_LANGUAGE);
                        } else {
                            this.occurence.init((CharSequence)binding, 0, binding.length(), WordOccurrence.Kind.FOREIGN_LANGUAGE);
                        }
                        processor.process((Object)this.occurence);
                    }
                    return true;
                }
            });
        }
        catch (AlienFormFileException | UnexpectedFormElementException | JDOMParseException container) {
        }
        catch (Exception e) {
            LOG.error("Error indexing form file", (Throwable)e);
        }
    }

    private static void processClassAndPackagesNames(String qName, Processor<WordOccurrence> processor) {
        WordOccurrence occurrence = new WordOccurrence((CharSequence)qName, 0, qName.length(), WordOccurrence.Kind.FOREIGN_LANGUAGE);
        processor.process((Object)occurrence);
        int idx = qName.lastIndexOf(46);
        while (idx > 0) {
            qName = qName.substring(0, idx);
            occurrence.init((CharSequence)qName, 0, qName.length(), WordOccurrence.Kind.FOREIGN_LANGUAGE);
            processor.process((Object)occurrence);
            idx = qName.lastIndexOf(46);
        }
    }
}

