/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm;
import com.jetbrains.plugins.remotesdk.ui.StatusPanel;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantCredentialsEditor
implements PanelWithAnchor {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myVagrantInstanceTextField;
    private JBLabel myVagrantInstanceLabel;
    private JLabel myVagrantHostLabel;
    private JLabel myVagrantHostUrl;
    private JLabel myMachineNameLabel;
    private ComboBox myMachineNameCombo;
    @NotNull
    private final VagrantSupport myVagrantSupport;
    @NotNull
    private final CreateRemoteSdkForm<? extends RemoteSdkAdditionalData> myParentForm;
    private VagrantBasedCredentialsHolder myVagrantCredentials;
    private RemoteCredentials myRemoteCredentials;
    @Nullable
    private JComponent myAnchor;

    public VagrantCredentialsEditor(@NotNull VagrantSupport vagrantSupport, @NotNull CreateRemoteSdkForm<? extends RemoteSdkAdditionalData> parentForm) {
        String vagrantFolder;
        if (vagrantSupport == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(0);
        }
        if (parentForm == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(1);
        }
        this.myVagrantSupport = vagrantSupport;
        this.myParentForm = parentForm;
        this.$$$setupUI$$$();
        FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myVagrantInstanceTextField.addBrowseFolderListener(new TextBrowseFolderListener(folderDescriptor){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                VagrantCredentialsEditor.this.setVagrantMachineSelectionVisible(false);
                VagrantCredentialsEditor.this.vagrantSelected(chosenFile.getPath(), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor$1", "onFileChosen"));
            }
        });
        this.myVagrantInstanceTextField.setEditable(false);
        this.setVagrantMachineSelectionVisible(false);
        if (parentForm.getProject() != null && (vagrantFolder = this.myVagrantSupport.findVagrantFolder(parentForm.getProject())) != null) {
            this.myVagrantInstanceTextField.setText(FileUtil.toSystemDependentName((String)vagrantFolder));
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void onSelected() {
        if (!StringUtil.isEmpty((String)this.myVagrantInstanceTextField.getText())) {
            this.vagrantSelected(this.myVagrantInstanceTextField.getText(), this.getVagrantMachineName());
        }
    }

    @Nullable
    public String getVagrantMachineName() {
        if (!this.isVagrantMultipleMachines()) {
            return null;
        }
        return this.myMachineNameCombo.getSelectedItem() != null ? this.myMachineNameCombo.getSelectedItem().toString() : null;
    }

    public void vagrantSelected(@NotNull String vagrantFolder, @Nullable String machineName) {
        if (vagrantFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(2);
        }
        StatusPanel.Action loadConfigAction = this.myParentForm.getStatusPanel().progress("Loading Vagrant config");
        if (StringUtil.isNotEmpty((String)machineName)) {
            if (!this.isVagrantMultipleMachines()) {
                this.initVagrantMachineSelection(vagrantFolder, machineName);
            }
        } else {
            List machineNames;
            if (!this.isVagrantMultipleMachines() && (machineNames = this.myVagrantSupport.getMachineNames(vagrantFolder)).size() > 1) {
                this.setMultipleMachinesMode(vagrantFolder, machineName, machineNames);
            }
            if (this.isVagrantMultipleMachines()) {
                loadConfigAction.failed("Multiple machine configuration detected: please select machine name");
                return;
            }
        }
        this.updateStatus(vagrantFolder, machineName, loadConfigAction, 0);
    }

    public boolean isVagrantMultipleMachines() {
        return this.myMachineNameLabel.isVisible();
    }

    public boolean initVagrantMachineSelection(@NotNull String vagrantFolder, @Nullable String machineName) {
        List machineNames;
        if (vagrantFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(3);
        }
        if ((machineNames = this.myVagrantSupport.getMachineNames(vagrantFolder)).size() > 1) {
            this.setMultipleMachinesMode(vagrantFolder, machineName, machineNames);
            return true;
        }
        return false;
    }

    public void setMultipleMachinesMode(final @NotNull String vagrantFolder, @Nullable String machineName, List<String> machineNames) {
        if (vagrantFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(4);
        }
        for (ItemListener l : Lists.newArrayList((Object[])this.myMachineNameCombo.getItemListeners())) {
            this.myMachineNameCombo.removeItemListener(l);
        }
        this.myMachineNameCombo.setModel((ComboBoxModel)new CollectionComboBoxModel((List)Lists.newArrayList((Iterable)Iterables.concat(Collections.singletonList(null), machineNames))));
        this.myMachineNameCombo.setSelectedItem((Object)machineName);
        this.myMachineNameCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VagrantCredentialsEditor.this.vagrantSelected(vagrantFolder, VagrantCredentialsEditor.this.getVagrantMachineName());
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> this.setVagrantMachineSelectionVisible(true));
    }

    private void setVagrantMachineSelectionVisible(boolean visible) {
        this.myMachineNameCombo.setVisible(visible);
        this.myMachineNameLabel.setVisible(visible);
    }

    private void updateStatus(final @NotNull String vagrantFolder, final @Nullable String machineName, final StatusPanel.Action loadConfigAction, final int recursion) {
        if (vagrantFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(5);
        }
        if (recursion > 5) {
            loadConfigAction.failed("Couldn't connect to Vagrant");
            return;
        }
        Futures.addCallback((ListenableFuture)this.myVagrantSupport.computeVagrantSettings(this.myParentForm.getProject(), vagrantFolder, machineName), (FutureCallback)new FutureCallback<RemoteCredentials>(){

            public void onSuccess(@Nullable RemoteCredentials credentials) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (vagrantFolder == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    loadConfigAction.done();
                    VagrantCredentialsEditor.this.useVagrantSettings(credentials, vagrantFolder, machineName);
                });
            }

            public void onFailure(Throwable t) {
                if (t instanceof VagrantSupport.MultipleMachinesException) {
                    if (VagrantCredentialsEditor.this.initVagrantMachineSelection(vagrantFolder, machineName)) {
                        VagrantCredentialsEditor.this.vagrantSelected(vagrantFolder, machineName);
                        loadConfigAction.done();
                        return;
                    }
                } else if (VagrantCredentialsEditor.this.myVagrantSupport.isNotReadyForSsh(t) && VagrantCredentialsEditor.this.myVagrantSupport.checkVagrantRunning(vagrantFolder, machineName, true)) {
                    VagrantCredentialsEditor.this.updateStatus(vagrantFolder, machineName, loadConfigAction, recursion + 1);
                    return;
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    VagrantCredentialsEditor.this.myVagrantHostUrl.setText("");
                    loadConfigAction.failed("Can't Get Vagrant Settings: \n" + t.getMessage());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor$3", "lambda$onSuccess$0"));
            }
        });
    }

    private void useVagrantSettings(@Nullable RemoteCredentials credentials, @NotNull String instanceFolder, @Nullable String machineName) {
        if (instanceFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(6);
        }
        if (this.myParentForm.isSdkInConsistentState(CredentialsType.VAGRANT)) {
            this.setVagrantCredentials(credentials, new VagrantBasedCredentialsHolder(instanceFolder, machineName));
            this.myVagrantInstanceTextField.setText(instanceFolder);
            if (StringUtil.isNotEmpty((String)machineName) && !this.isVagrantMultipleMachines()) {
                this.initVagrantMachineSelection(instanceFolder, machineName);
            }
        }
    }

    private void setVagrantCredentials(@Nullable RemoteCredentials credentials, @NotNull VagrantBasedCredentialsHolder vagrantCredentials) {
        if (vagrantCredentials == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(7);
        }
        this.myVagrantCredentials = vagrantCredentials;
        this.myParentForm.useReferencedCredentials(credentials, this.myVagrantHostLabel, this.myVagrantHostUrl, () -> {
            if (vagrantCredentials == null) {
                VagrantCredentialsEditor.$$$reportNull$$$0(9);
            }
            if (!this.myVagrantSupport.checkVagrantRunning(vagrantCredentials.getVagrantFolder(), vagrantCredentials.getMachineName(), true)) {
                this.myParentForm.validateWithValidator();
            }
        });
    }

    @Nullable
    public ValidationInfo validate(@NotNull Ref<FileTransferConfig> configRef, boolean allowSlowActions) {
        if (configRef == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)this.myVagrantInstanceTextField.getText())) {
            return new ValidationInfo("Vagrant instance folder is not specified", (JComponent)this.myVagrantInstanceTextField);
        }
        if (this.myRemoteCredentials != null) {
            configRef.set((Object)CreateRemoteSdkForm.credentialsAsFileTransferConfig(this.myRemoteCredentials));
            return null;
        }
        if (this.myVagrantCredentials == null) {
            return new ValidationInfo("Cant obtain ssh credentials for Vagrant at " + this.myVagrantInstanceTextField.getText());
        }
        try {
            if (!allowSlowActions) {
                return new ValidationInfo("No credentials for Vagrant remote interpreter was loaded");
            }
            this.myRemoteCredentials = this.myVagrantSupport.getCredentials(this.myVagrantCredentials.getVagrantFolder(), this.myVagrantCredentials.getMachineName());
        }
        catch (Exception e) {
            return new ValidationInfo(e.getMessage() != null ? e.getMessage() : "Error create Vagrant remote interpreter:" + e.getClass().toString());
        }
        return null;
    }

    @Nullable
    public VagrantBasedCredentialsHolder getVagrantCredentials() {
        return this.myVagrantCredentials;
    }

    public void initVagrantSettings(VagrantBasedCredentialsHolder cred) {
        this.useVagrantSettings(null, cred.getVagrantFolder(), cred.getMachineName());
        this.vagrantSelected(cred.getVagrantFolder(), cred.getMachineName());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myVagrantInstanceTextField.getChildComponent();
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myVagrantInstanceLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantSupport";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForm";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceFolder";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantCredentials";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configRef";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "vagrantSelected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initVagrantMachineSelection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setMultipleMachinesMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateStatus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "useVagrantSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setVagrantCredentials";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setVagrantCredentials$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myVagrantInstanceTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myVagrantInstanceLabel = jBLabel = new JBLabel();
        jBLabel.setText("Vagrant Instance Folder:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(17);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVagrantHostLabel = jLabel3 = new JLabel();
        jLabel3.setText("Vagrant Host URL:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myVagrantHostUrl = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, new Dimension(7, -1), null, new Dimension(7, -1)));
        this.myMachineNameLabel = jLabel = new JLabel();
        jLabel.setText("Machine name:");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMachineNameCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

