/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.remote.RemoteConnectionType;
import java.nio.charset.Charset;

@com.intellij.openapi.components.State(name="SshConsoleOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SshConsoleOptionsProvider
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static SshConsoleOptionsProvider getInstance(Project project) {
        return (SshConsoleOptionsProvider)ServiceManager.getService((Project)project, SshConsoleOptionsProvider.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState.myEncoding = state.myEncoding;
        this.myState.myConnectionType = state.myConnectionType;
        this.myState.myConnectionId = state.myConnectionId;
    }

    public void setCharset(Charset charset) {
        this.myState.myEncoding = charset != null ? charset.name() : null;
    }

    public void setConnectByDefaultType(RemoteConnectionType connectionType) {
        this.myState.myConnectionType = connectionType.name();
    }

    public RemoteConnectionType getConnectionType() {
        return RemoteConnectionType.findByName((String)this.myState.myConnectionType);
    }

    public String getConnectionId() {
        return this.myState.myConnectionId;
    }

    public void setConnectionId(String id) {
        this.myState.myConnectionId = id;
    }

    public Charset getCharset() {
        Charset charset = this.myState.myEncoding != null ? CharsetToolkit.forName((String)this.myState.myEncoding) : null;
        return charset != null ? charset : Charset.defaultCharset();
    }

    public static class State {
        public String myEncoding;
        public String myConnectionType;
        public String myConnectionId;
    }
}

