/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BindingComparator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;

class VariableBinding
implements IVariableBinding {
    private static final int VALID_MODIFIERS = 223;
    private org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding;
    private ITypeBinding declaringClass;
    private String key;
    private String name;
    private BindingResolver resolver;
    private ITypeBinding type;

    VariableBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public Object getConstantValue() {
        Constant c = this.binding.constant();
        if (c == null || c == Constant.NotAConstant) {
            return null;
        }
        switch (c.typeID()) {
            case 5: {
                return c.booleanValue();
            }
            case 3: {
                return new Byte(c.byteValue());
            }
            case 2: {
                return new Character(c.charValue());
            }
            case 8: {
                return new Double(c.doubleValue());
            }
            case 9: {
                return new Float(c.floatValue());
            }
            case 10: {
                return new Integer(c.intValue());
            }
            case 7: {
                return new Long(c.longValue());
            }
            case 4: {
                return new Short(c.shortValue());
            }
            case 11: {
                return c.stringValue();
            }
        }
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.isField()) {
            if (this.declaringClass == null) {
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                this.declaringClass = this.resolver.getTypeBinding(fieldBinding.declaringClass);
            }
            return this.declaringClass;
        }
        return null;
    }

    public IMethodBinding getDeclaringMethod() {
        if (!this.isField()) {
            for (ASTNode node = this.resolver.findDeclaringNode(this); node != null; node = node.getParent()) {
                switch (node.getNodeType()) {
                    case 28: {
                        return null;
                    }
                    case 31: {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)node;
                        return methodDeclaration.resolveBinding();
                    }
                }
            }
        }
        return null;
    }

    public IVariableBinding getVariableDeclaration() {
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            return this.resolver.getVariableBinding(fieldBinding.original());
        }
        return this;
    }

    public IJavaElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        int nameLength;
        int nameStart;
        int sourceLength;
        int sourceStart;
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if (fieldBinding.declaringClass == null) {
                return null;
            }
            IType declaringType = (IType)this.getDeclaringClass().getJavaElement();
            if (declaringType == null) {
                return null;
            }
            return (JavaElement)((Object)declaringType.getField(this.getName()));
        }
        IMethodBinding declaringMethod = this.getDeclaringMethod();
        if (declaringMethod == null) {
            return null;
        }
        JavaElement method = (JavaElement)declaringMethod.getJavaElement();
        if (!(this.resolver instanceof DefaultBindingResolver)) {
            return null;
        }
        VariableDeclaration localVar = (VariableDeclaration)((DefaultBindingResolver)this.resolver).bindingsToAstNodes.get(this);
        if (localVar == null) {
            return null;
        }
        if (localVar instanceof SingleVariableDeclaration) {
            sourceStart = localVar.getStartPosition();
            sourceLength = localVar.getLength();
            SimpleName simpleName = ((SingleVariableDeclaration)localVar).getName();
            nameStart = simpleName.getStartPosition();
            nameLength = simpleName.getLength();
        } else {
            nameStart = localVar.getStartPosition();
            nameLength = localVar.getLength();
            ASTNode node = localVar.getParent();
            sourceStart = node.getStartPosition();
            sourceLength = node.getLength();
        }
        char[] typeSig = this.binding.type.genericTypeSignature();
        return new LocalVariable(method, localVar.getName().getIdentifier(), sourceStart, sourceStart + sourceLength - 1, nameStart, nameStart + nameLength - 1, new String(typeSig));
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).getAccessFlags() & 0xDF;
        }
        if (this.binding.isFinal()) {
            return 16;
        }
        return 0;
    }

    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.name);
        }
        return this.name;
    }

    public ITypeBinding getType() {
        if (this.type == null) {
            this.type = this.resolver.getTypeBinding(this.binding.type);
        }
        return this.type;
    }

    public int getVariableId() {
        return this.binding.id;
    }

    public boolean isDeprecated() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isDeprecated();
        }
        return false;
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof VariableBinding)) {
            return false;
        }
        org.eclipse.jdt.internal.compiler.lookup.VariableBinding otherBinding = ((VariableBinding)other).binding;
        if (this.binding instanceof FieldBinding) {
            if (otherBinding instanceof FieldBinding) {
                return BindingComparator.isEqual((FieldBinding)this.binding, (FieldBinding)otherBinding);
            }
            return false;
        }
        if (BindingComparator.isEqual(this.binding, otherBinding)) {
            IMethodBinding declaringMethod = this.getDeclaringMethod();
            IMethodBinding otherDeclaringMethod = ((VariableBinding)other).getDeclaringMethod();
            if (declaringMethod == null) {
                return otherDeclaringMethod == null;
            }
            return declaringMethod.isEqualTo(otherDeclaringMethod);
        }
        return false;
    }

    public boolean isField() {
        return this.binding instanceof FieldBinding;
    }

    public boolean isEnumConstant() {
        return (this.binding.modifiers & 0x4000) != 0;
    }

    public boolean isSynthetic() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isSynthetic();
        }
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }
}

