/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.agent;

import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.SimpleAgentBase;
import com.intellij.javaee.oss.agent.SimpleAgentException;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.deploy.shared.ArchiveFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class Glassfish2Agent
extends SimpleAgentBase {
    private static final String SERVER = "amx:j2eeType=J2EEServer,name=server";
    private static final String[] TARGETS = new String[]{"server"};
    private MBeanServerConnection myConnection;
    private DeploymentFacility myFacility;

    public void destroy() {
    }

    protected boolean doConnect() throws IOException, JMException, SimpleAgentException {
        if (this.myConnection == null) {
            this.myConnection = this.createConnection();
        }
        if (!(this.myConnection.getAttribute(new ObjectName(SERVER), "state") instanceof Integer)) {
            return false;
        }
        if (this.myFacility == null) {
            this.myFacility = this.createDeploymentFacility();
        }
        return true;
    }

    public void disconnect() {
        if (this.myFacility != null) {
            this.myFacility.disconnect();
        }
    }

    protected void doDeploy(String deploymentName, File source, ParametersMap deployParameters) throws IOException, JMException, SimpleAgentException {
        try {
            String prefix = source.isDirectory() ? "file" : "jar";
            URI uri = new URI(prefix, "", source.toURI().getSchemeSpecificPart(), null, null);
            AbstractArchive archive = new ArchiveFactory().openArchive(uri);
            Properties options = new Properties();
            options.setProperty("target", TARGETS[0]);
            options.setProperty("archiveName", source.getAbsolutePath());
            options.setProperty("name", deploymentName);
            boolean needContextRoot = Boolean.parseBoolean((String)deployParameters.get((Object)"need.context.root"));
            if (needContextRoot) {
                options.setProperty("contextRoot", deploymentName);
            }
            this.myFacility.waitFor(this.myFacility.deploy(this.myFacility.createTargets(TARGETS), (Archive)archive, null, (Map)options));
        }
        catch (URISyntaxException e) {
            throw new SimpleAgentException((Exception)e);
        }
    }

    protected void doUndeploy(String deploymentName) throws IOException, JMException, SimpleAgentException {
        this.myFacility.waitFor(this.myFacility.undeploy(this.myFacility.createTargets(TARGETS), deploymentName));
    }

    protected boolean doIsDeployed(String deploymentName) throws IOException, JMException, SimpleAgentException {
        TargetModuleID[] modules;
        for (TargetModuleID module : modules = this.myFacility.listAppRefs(TARGETS)) {
            if (!deploymentName.equals(module.getModuleID())) continue;
            return true;
        }
        return false;
    }

    private MBeanServerConnection createConnection() throws IOException {
        JMXServiceURL url = new JMXServiceURL("s1ashttp", this.getHost(), this.getPort());
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.credentials", new String[]{this.getUsername(), this.getPassword()});
        env.put("com.sun.enterprise.as.http.auth", "BASIC");
        env.put("USER", this.getUsername());
        env.put("PASSWORD", this.getPassword());
        env.put("jmx.remote.protocol.provider.pkgs", "com.sun.enterprise.admin.jmx.remote.protocol");
        return JMXConnectorFactory.connect(url, env).getMBeanServerConnection();
    }

    private DeploymentFacility createDeploymentFacility() {
        DeploymentFacility facility = DeploymentFacilityFactory.getDeploymentFacility();
        ServerConnectionIdentifier identifier = new ServerConnectionIdentifier();
        identifier.setHostName(this.getHost());
        identifier.setHostPort(this.getPort());
        identifier.setUserName(this.getUsername());
        identifier.setPassword(this.getPassword());
        identifier.setSecure(false);
        facility.connect(identifier);
        return facility;
    }
}

