/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public final class SpringMvcLibraryUtil {
    public static final PatternCondition<PsiElement> IS_SPRING_MVC_PROJECT = new PatternCondition<PsiElement>("isSpringMVCEnabledProject"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return SpringMvcLibraryUtil.isSpringMVCEnabled(element.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/SpringMvcLibraryUtil$1", "accepts"));
        }
    };

    public static boolean hasSpringMvcLibrary(@NotNull Project project) {
        if (project == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(0);
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.web.servlet.DispatcherServlet", ProjectScope.getLibrariesScope((Project)project)) != null;
    }

    public static boolean hasSpringMvcLibrary(@NotNull Module module) {
        if (module == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(1);
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet") != null;
    }

    public static boolean isSpringMVCEnabled(Project project) {
        return SpringCommonUtils.hasSpringFacets((Project)project) && ProjectFacetManager.getInstance((Project)project).hasFacets(WebFacet.ID) && SpringMvcLibraryUtil.hasSpringMvcLibrary(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/web/mvc/SpringMvcLibraryUtil";
        objectArray[2] = "hasSpringMvcLibrary";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

