/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.PluginState;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.PluginsTableRenderer;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.CloudConfigIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import messages.CloudConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarInfoManager {
    private static final String ID = "CloudConfig";
    public static final StatusBarInfoManager EMPTY = new StatusBarInfoManager(){

        @Override
        public void update(boolean create) {
        }
    };
    private static final NotificationGroup GROUP = new NotificationGroup("JBA Cloud Config", NotificationDisplayType.STICKY_BALLOON, true);
    private static boolean myOldRegistryValue;

    public void update(boolean create) {
        WindowManager windowManager = WindowManager.getInstance();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar = windowManager.getStatusBar(project);
            StatusBarWidget widget = statusBar.getWidget(ID);
            if (widget instanceof InfoComponent) {
                ((InfoComponent)widget).update();
                continue;
            }
            if (create) {
                statusBar.addWidget((StatusBarWidget)new InfoComponent());
                CloudConfigManager.LOG.info("=== StatusBar.update create ===");
                continue;
            }
            CloudConfigManager.LOG.info("=== StatusBar.update another widget: " + widget + " ===");
        }
    }

    private static boolean isConnected() {
        return CloudConfigManager.getInstance().getStatusInfo() == StatusInfo.JBA_CONNECTED;
    }

    private static void showLoginMessage() {
        CloudConfigManager.getInstance().updateUserInfo(() -> StatusBarInfoManager.showErrorMessage(CloudConfigBundle.message("login.dialog.message", new Object[0]), CloudConfigBundle.message("login.dialog.title", new Object[0])));
    }

    private static void showOfflineMessage() {
        StatusBarInfoManager.offDialogsAsSheets();
        Messages.showInfoMessage((String)CloudConfigBundle.message("offline.dialog.message", new Object[0]), (String)CloudConfigBundle.message("offline.dialog.title", new Object[0]));
        StatusBarInfoManager.resetDialogsAsSheets();
    }

    private static void showUpdateApiDialog() {
        StatusBarInfoManager.offDialogsAsSheets();
        int exitCode = Messages.showOkCancelDialog((String)CloudConfigBundle.message("update.api.dialog.message", new Object[0]), (String)CloudConfigBundle.message("dialog.title", new Object[0]), (String)CloudConfigBundle.message("update.api.dialog.button", new Object[0]), (String)Messages.CANCEL_BUTTON, (Icon)Messages.getInformationIcon());
        StatusBarInfoManager.resetDialogsAsSheets();
        if (exitCode == 0) {
            CloudConfigManager.getInstance().doUpdateApi();
        }
    }

    private static Runnable showPopupMessage(@Nullable Project project) {
        return () -> {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar == null) {
                return;
            }
            JComponent component = ((IdeStatusBarImpl)statusBar).getWidgetComponent(ID);
            if (component == null) {
                return;
            }
            CloudConfigManager manager = CloudConfigManager.getInstance();
            String message = CloudConfigBundle.message(manager.getStatusInfo() == StatusInfo.JBA_IO_ERROR ? "error.connected.message" : (manager.hasPluginsUpdate() ? "update.plugins.message" : "connected.message"), new Object[0]);
            IdeTooltip tooltip = new IdeTooltip((Component)component, new Point(), (JComponent)new JLabel(message), new Object[0]);
            IdeTooltipManager.getInstance().show(tooltip, true, false);
        };
    }

    public static void showStartNotification() {
        Notification notification = new Notification(GROUP.getDisplayId(), CloudConfigBundle.message("accepted.title", new Object[0]), CloudConfigBundle.message("accepted.message", new Object[0]), NotificationType.INFORMATION);
        notification.setIcon(AllIcons.General.Settings);
        notification.addAction((AnAction)new NotificationAction(CloudConfigBundle.message("enable.cloud.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                Project project = e.getProject();
                notification.expire();
                StatusBarInfoManager.connectInstance(StatusBarInfoManager.showPopupMessage(project));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/cloudConfig/StatusBarInfoManager$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(null);
    }

    public static void showUpdateApiNotification() {
        Notification notification = new Notification(GROUP.getDisplayId(), CloudConfigBundle.message("dialog.title", new Object[0]), CloudConfigBundle.message("update.api.notification.message", new Object[0]), NotificationType.INFORMATION);
        notification.setIcon(AllIcons.General.Settings);
        notification.addAction((AnAction)new NotificationAction(CloudConfigBundle.message("update.api.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                notification.expire();
                StatusBarInfoManager.showUpdateApiDialog();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/cloudConfig/StatusBarInfoManager$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(null);
    }

    public static void showErrorMessage(@Nullable String message) {
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = CloudConfigBundle.message("default.error.message", new Object[0]);
        }
        StatusBarInfoManager.showErrorMessage(message, CloudConfigBundle.message("error.message.title", new Object[0]));
    }

    private static void showErrorMessage(@NotNull String message, @NotNull String title) {
        if (message == null) {
            StatusBarInfoManager.$$$reportNull$$$0(0);
        }
        if (title == null) {
            StatusBarInfoManager.$$$reportNull$$$0(1);
        }
        StatusBarInfoManager.offDialogsAsSheets();
        Messages.showErrorDialog((String)message, (String)title);
        StatusBarInfoManager.resetDialogsAsSheets();
    }

    private static void connectInstance(@NotNull Runnable successRun) {
        CloudConfigManager manager;
        if (successRun == null) {
            StatusBarInfoManager.$$$reportNull$$$0(2);
        }
        if ((manager = CloudConfigManager.getInstance()).getStatusInfo() == StatusInfo.JBA_NOT_CONNECTED) {
            Boolean result = MyMessages.showDialog("connect.message", "connect.button", "connect.plugins.auto");
            if (result != null) {
                manager.setAutoUpdatePlugins(result);
                manager.connectFirstInstance(false, successRun);
            }
        } else {
            boolean[] autoUpdatePlugins = new boolean[1];
            int result = MyMessages.showCheckboxDialog(CloudConfigBundle.message("connect.this.message", CloudConfigClientUtil.getUserLogin()), new String[]{CloudConfigBundle.message("connect.this.remote.button", new Object[0]), CloudConfigBundle.message("connect.this.local.button", new Object[0]), Messages.CANCEL_BUTTON}, CloudConfigBundle.message("connect.plugins.auto", new Object[0]), (PairFunction<Integer, JCheckBox, Integer>)((PairFunction)(exitCode, checkBox) -> {
                autoUpdatePlugins[0] = checkBox.isSelected();
                return exitCode;
            }));
            if (result == 0 || result == 1) {
                manager.setAutoUpdatePlugins(autoUpdatePlugins[0]);
                if (result == 0) {
                    manager.connectThisInstance(true, false, successRun);
                } else {
                    manager.connectFirstInstance(true, successRun);
                }
            }
        }
    }

    private static void offDialogsAsSheets() {
        if (SystemInfo.isMac) {
            RegistryValue value = Registry.get((String)"ide.mac.message.dialogs.as.sheets");
            myOldRegistryValue = value.asBoolean();
            value.setValue(false);
        }
    }

    private static void resetDialogsAsSheets() {
        if (SystemInfo.isMac) {
            Registry.get((String)"ide.mac.message.dialogs.as.sheets").setValue(myOldRegistryValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successRun";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "connectInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EditPluginState {
        private final PluginState myState;
        private PluginState.Operation myOperation;

        public EditPluginState(@NotNull PluginState state) {
            if (state == null) {
                EditPluginState.$$$reportNull$$$0(0);
            }
            this.myOperation = PluginState.Operation.Auto;
            this.myState = state;
            if (state.skip) {
                this.myOperation = state.local ? PluginState.Operation.SkipLocally : PluginState.Operation.SkipEverywhere;
            }
        }

        private EditPluginState(@NotNull PluginState.Operation operation) {
            if (operation == null) {
                EditPluginState.$$$reportNull$$$0(1);
            }
            this.myOperation = PluginState.Operation.Auto;
            this.myState = null;
            this.myOperation = operation;
        }

        @NotNull
        public static EditPluginState[] getStates() {
            PluginState.Operation[] values = PluginState.Operation.values();
            EditPluginState[] states = new EditPluginState[values.length];
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                states[i] = new EditPluginState(values[i]);
            }
            if (states == null) {
                EditPluginState.$$$reportNull$$$0(2);
            }
            return states;
        }

        @NotNull
        public String getPluginStatus() {
            switch (this.myState.type) {
                case Install: {
                    if ("Not Installed" == null) {
                        EditPluginState.$$$reportNull$$$0(3);
                    }
                    return "Not Installed";
                }
                case Uninstall: {
                    if ("Installed" == null) {
                        EditPluginState.$$$reportNull$$$0(4);
                    }
                    return "Installed";
                }
                case Disable: {
                    if ("Enabled" == null) {
                        EditPluginState.$$$reportNull$$$0(5);
                    }
                    return "Enabled";
                }
            }
            if ("Disabled" == null) {
                EditPluginState.$$$reportNull$$$0(6);
            }
            return "Disabled";
        }

        @NotNull
        public String getOperationName(PluginState.Operation operation) {
            switch (operation) {
                case Revert: {
                    String string = this.getRevertName();
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                case SkipEverywhere: {
                    if ("Skip Everywhere" == null) {
                        EditPluginState.$$$reportNull$$$0(8);
                    }
                    return "Skip Everywhere";
                }
                case SkipLocally: {
                    if ("Skip" == null) {
                        EditPluginState.$$$reportNull$$$0(9);
                    }
                    return "Skip";
                }
            }
            String string = this.myState.type.name();
            if (string == null) {
                EditPluginState.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        private String getRevertName() {
            switch (this.myState.type) {
                case Install: {
                    if ("Uninstall Everywhere" == null) {
                        EditPluginState.$$$reportNull$$$0(11);
                    }
                    return "Uninstall Everywhere";
                }
                case Uninstall: {
                    if ("Install Everywhere" == null) {
                        EditPluginState.$$$reportNull$$$0(12);
                    }
                    return "Install Everywhere";
                }
                case Disable: {
                    if ("Enable Everywhere" == null) {
                        EditPluginState.$$$reportNull$$$0(13);
                    }
                    return "Enable Everywhere";
                }
            }
            if ("Disable Everywhere" == null) {
                EditPluginState.$$$reportNull$$$0(14);
            }
            return "Disable Everywhere";
        }

        @Nullable
        public PluginState.Operation getOperation() {
            if (this.myState.skip && (this.myState.local ? this.myOperation == PluginState.Operation.SkipLocally : this.myOperation == PluginState.Operation.SkipEverywhere)) {
                return null;
            }
            return this.myOperation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EditPluginState)) {
                return false;
            }
            EditPluginState state = (EditPluginState)o;
            return this.myOperation == state.myOperation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager$EditPluginState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$EditPluginState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStates";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPluginStatus";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOperationName";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevertName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PluginModel
    extends PluginTableModel {
        final Map<IdeaPluginDescriptor, EditPluginState> myStates = new HashMap<IdeaPluginDescriptor, EditPluginState>();
        Runnable myOkHandler;

        public PluginModel() {
            this.columns = new ColumnInfo[]{new PluginManagerColumnInfo(0, this){

                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : new PluginsTableRenderer(descriptor, false){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            this.myName.append(" ").append(myStates.get(this.myPluginDescriptor).getPluginStatus(), isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
                            ((JComponent)component).setToolTipText(null);
                            this.myName.setForeground((Color)UIUtil.getCellColors((JTable)table, (boolean)isSelected, (int)row, (int)column).getFirst());
                            return component;
                        }
                    };
                }
            }, new ColumnInfo<IdeaPluginDescriptor, EditPluginState>(""){

                @Nullable
                public EditPluginState valueOf(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : myStates.get(descriptor);
                }

                public boolean isCellEditable(IdeaPluginDescriptor descriptor) {
                    return true;
                }

                @Nullable
                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : new ComboBoxTableRenderer<EditPluginState>(null){

                        protected String getTextFor(@NotNull EditPluginState value) {
                            if (value == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return value.getOperationName(value.myOperation);
                        }

                        protected void customizeComponent(EditPluginState value, JTable table, boolean isSelected) {
                            super.customizeComponent((Object)value, table, isSelected);
                            if (!isSelected && value.getOperation() == null) {
                                this.setForeground(SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/StatusBarInfoManager$PluginModel$2$1", "getTextFor"));
                        }
                    };
                }

                public TableCellEditor getEditor(IdeaPluginDescriptor descriptor) {
                    return new ComboBoxTableRenderer<EditPluginState>(EditPluginState.getStates()){
                        private EditPluginState myValue;

                        public boolean isCellEditable(EventObject event) {
                            if (event instanceof MouseEvent) {
                                return ((MouseEvent)event).getClickCount() >= 1;
                            }
                            return false;
                        }

                        protected String getTextFor(@NotNull EditPluginState value) {
                            if (value == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return this.myValue.getOperationName(value.myOperation);
                        }

                        protected ListSeparator getSeparatorAbove(EditPluginState value) {
                            return value.myOperation == PluginState.Operation.SkipLocally ? new ListSeparator() : null;
                        }

                        protected void customizeComponent(EditPluginState value, JTable table, boolean isSelected) {
                            this.myValue = value;
                            super.customizeComponent((Object)value, table, isSelected);
                            if (value.getOperation() == null) {
                                this.setForeground(SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/StatusBarInfoManager$PluginModel$2$2", "getTextFor"));
                        }
                    };
                }

                public void setValue(IdeaPluginDescriptor descriptor, EditPluginState value) {
                    myStates.get(descriptor).myOperation = value.myOperation;
                    myOkHandler.run();
                }
            }};
            CloudConfigManager manager = CloudConfigManager.getInstance();
            this.addItems(manager.getInstalledUninstalledPlugins());
            this.addItems(manager.getEnabledDisabledPlugins());
        }

        public void setOkButton(@NotNull Action okButton) {
            if (okButton == null) {
                PluginModel.$$$reportNull$$$0(0);
            }
            this.myOkHandler = () -> {
                if (okButton == null) {
                    PluginModel.$$$reportNull$$$0(2);
                }
                boolean result = false;
                for (EditPluginState renderer : this.myStates.values()) {
                    if (renderer.getOperation() == null) continue;
                    result = true;
                    break;
                }
                okButton.setEnabled(result);
            };
            this.myOkHandler.run();
        }

        private void addItems(@NotNull List<PluginState> states) {
            if (states == null) {
                PluginModel.$$$reportNull$$$0(1);
            }
            for (PluginState state : states) {
                this.view.add(state.plugin);
                this.myStates.put(state.plugin, new EditPluginState(state));
            }
        }

        public void updatePluginsList(List<IdeaPluginDescriptor> list) {
        }

        public int getNameColumn() {
            return 0;
        }

        public boolean isPluginDescriptorAccepted(IdeaPluginDescriptor descriptor) {
            return true;
        }

        public boolean isSortable() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "okButton";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "states";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$PluginModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setOkButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItems";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$setOkButton$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyMessages
    extends Messages {
        private MyMessages() {
        }

        public static int showCheckboxDialog(String message, @NotNull String[] options, String checkboxText, @Nullable PairFunction<Integer, JCheckBox, Integer> exitFunc) {
            if (options == null) {
                MyMessages.$$$reportNull$$$0(0);
            }
            StatusBarInfoManager.offDialogsAsSheets();
            Messages.TwoStepConfirmationDialog dialog = new Messages.TwoStepConfirmationDialog(message, CloudConfigBundle.message("dialog.title", new Object[0]), options, checkboxText, false, 0, 0, Messages.getInformationIcon(), exitFunc){

                protected JComponent createSouthPanel() {
                    this.setButtonsAlignment(4);
                    JComponent panel = super.createSouthPanel();
                    Container buttons = MyMessages.findGridPanel(panel);
                    assert (buttons != null);
                    final int hgap = ((GridLayout)buttons.getLayout()).getHgap();
                    buttons.setLayout(new LayoutManager(){

                        @Override
                        public void addLayoutComponent(String name, Component comp) {
                        }

                        @Override
                        public void removeLayoutComponent(Component comp) {
                        }

                        @Override
                        public Dimension minimumLayoutSize(Container parent) {
                            return this.preferredLayoutSize(parent);
                        }

                        @Override
                        public Dimension preferredLayoutSize(Container parent) {
                            Insets insets = parent.getInsets();
                            int components = parent.getComponentCount() - 1;
                            Dimension size = this.calculateSize(parent);
                            int lastWidth = parent.getComponent((int)components).getPreferredSize().width + JBUI.scale((int)50);
                            return new Dimension(insets.left + insets.right + components * size.width + lastWidth + components * hgap, insets.top + insets.bottom + size.height);
                        }

                        @NotNull
                        private Dimension calculateSize(@NotNull Container parent) {
                            if (parent == null) {
                                MyMessages.1.$$$reportNull$$$0(0);
                            }
                            int components = parent.getComponentCount();
                            Dimension size = new Dimension();
                            for (int i = 0; i < components; ++i) {
                                Component component = parent.getComponent(i);
                                Dimension d = component.getPreferredSize();
                                if (size.width < d.width) {
                                    size.width = d.width;
                                }
                                if (size.height >= d.height) continue;
                                size.height = d.height;
                            }
                            Dimension dimension = size;
                            if (dimension == null) {
                                MyMessages.1.$$$reportNull$$$0(1);
                            }
                            return dimension;
                        }

                        @Override
                        public void layoutContainer(Container parent) {
                            Insets insets = parent.getInsets();
                            Dimension size = this.calculateSize(parent);
                            int index = parent.getComponentCount() - 1;
                            Component lastButton = parent.getComponent(index--);
                            int lastWidth = lastButton.getPreferredSize().width;
                            int x = parent.getWidth() - insets.right - lastWidth;
                            int y = insets.top;
                            lastButton.setBounds(x, y, lastWidth, size.height);
                            while (index >= 0) {
                                parent.getComponent(index--).setBounds(x -= hgap + size.width, y, size.width, size.height);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "parent";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "calculateSize";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "calculateSize";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                    return panel;
                }

                protected JComponent createNorthPanel() {
                    if (SystemInfo.isMac && !this.myMessage.contains("\n")) {
                        JPanel panel = this.createIconPanel();
                        JPanel messagePanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)12)));
                        messagePanel.add(new JLabel(this.myMessage));
                        messagePanel.add(this.createCheckComponent());
                        panel.add((Component)messagePanel, "Center");
                        return panel;
                    }
                    return super.createNorthPanel();
                }

                @NotNull
                protected JComponent createCheckComponent() {
                    JComponent component = super.createCheckComponent();
                    if (SystemInfo.isWindows) {
                        int top = JBUI.scale((int)7);
                        int bottom = UIUtil.isUnderDarcula() ? 0 : top;
                        component.setBorder(BorderFactory.createEmptyBorder(top, 0, bottom, 0));
                    } else if (SystemInfo.isMac && this.myMessage.contains("\n")) {
                        int offset = JBUI.scale((int)(UIUtil.isUnderDarcula() ? 6 : 7));
                        component.setBorder(BorderFactory.createEmptyBorder(offset, 0, offset, 0));
                    } else if (SystemInfo.isLinux) {
                        component.setBorder(BorderFactory.createEmptyBorder(JBUI.scale((int)7), 0, 0, 0));
                    }
                    JComponent jComponent = component;
                    if (jComponent == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return jComponent;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1", "createCheckComponent"));
                }
            };
            dialog.show();
            StatusBarInfoManager.resetDialogsAsSheets();
            return dialog.getExitCode();
        }

        @Nullable
        private static Container findGridPanel(@NotNull Container parent) {
            if (parent == null) {
                MyMessages.$$$reportNull$$$0(1);
            }
            int count = parent.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component component = parent.getComponent(i);
                if (!(component instanceof Container)) continue;
                Container container = (Container)component;
                if (container.getLayout() instanceof GridLayout) {
                    return container;
                }
                Container result = MyMessages.findGridPanel(container);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Nullable
        public static Boolean showDialog(@NotNull String messageKey, @NotNull String okButtonKey, @NotNull String checkBoxKey) {
            int result;
            if (messageKey == null) {
                MyMessages.$$$reportNull$$$0(2);
            }
            if (okButtonKey == null) {
                MyMessages.$$$reportNull$$$0(3);
            }
            if (checkBoxKey == null) {
                MyMessages.$$$reportNull$$$0(4);
            }
            return (result = MyMessages.showCheckboxDialog(CloudConfigBundle.message(messageKey, new Object[0]), new String[]{CloudConfigBundle.message(okButtonKey, new Object[0]), Messages.CANCEL_BUTTON}, CloudConfigBundle.message(checkBoxKey, new Object[0]), (PairFunction<Integer, JCheckBox, Integer>)((PairFunction)(exitCode, checkBox) -> exitCode == 0 ? (checkBox.isSelected() ? 0 : 1) : 2))) == 2 ? null : Boolean.valueOf(result == 0);
        }

        public static void showPluginsDialog() {
            final PluginModel pluginModel = new PluginModel();
            StatusBarInfoManager.offDialogsAsSheets();
            Messages.TwoStepConfirmationDialog dialog = new Messages.TwoStepConfirmationDialog(CloudConfigBundle.message("plugins.dialog.message", new Object[0]), CloudConfigBundle.message("plugins.dialog.title", new Object[0]), new String[]{CloudConfigBundle.message("plugins.dialog.button", new Object[0]), Messages.CANCEL_BUTTON}, null, false, 0, 0, null, (exitCode, checkBox) -> exitCode){
                PluginTable myTable;

                protected JComponent createNorthPanel() {
                    return null;
                }

                protected JComponent createCenterPanel() {
                    JPanel messagePanel = this.createMessagePanel();
                    messagePanel.add(this.createCheckComponent());
                    return messagePanel;
                }

                @NotNull
                protected JComponent createCheckComponent() {
                    this.setButtonsAlignment(4);
                    this.myTable = new PluginTable((PluginTableModel)pluginModel);
                    JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
                    int width = this.myTable.getPreferredScrollableViewportSize().width;
                    pane.setPreferredSize(new Dimension(width, JBUI.scale((int)200)));
                    this.myTable.setColumnWidth(1, JBUI.scale((int)150));
                    JScrollPane jScrollPane = pane;
                    if (jScrollPane == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return jScrollPane;
                }

                public JComponent getPreferredFocusedComponent() {
                    return this.myTable;
                }

                @NotNull
                protected Action[] createActions() {
                    Action[] actions = super.createActions();
                    pluginModel.setOkButton(actions[0]);
                    if (actions == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return actions;
                }

                protected String getHelpId() {
                    return "cloud-config.plugin-dialog";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createCheckComponent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            dialog.show();
            StatusBarInfoManager.resetDialogsAsSheets();
            if (dialog.getExitCode() == 0) {
                CloudConfigManager.getInstance().executePlugins(pluginModel.myStates.values().stream().filter(editState -> editState.getOperation() != null).map(editState -> Pair.create((Object)((EditPluginState)editState).myState, (Object)((Object)editState.getOperation()))).collect(Collectors.toList()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageKey";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "okButtonKey";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checkBoxKey";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showCheckboxDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findGridPanel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showDialog";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InfoComponent
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation,
    DumbAware {
        private StatusBar myStatusBar;
        private Icon myIcon = EmptyIcon.ICON_16;
        private String myTooltip;
        private DefaultActionGroup myActions;
        private String myPopupTitle;
        private String myPopupBottomTitle;

        private InfoComponent() {
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                InfoComponent.$$$reportNull$$$0(0);
            }
            this.myStatusBar = statusBar;
            this.update();
        }

        public void update() {
            this.myActions = null;
            this.myTooltip = null;
            this.myPopupBottomTitle = null;
            this.myPopupTitle = null;
            CloudConfigManager manager = CloudConfigManager.getInstance();
            switch (manager.getStatusInfo()) {
                case JBA_NOT_FOUND: {
                    if (manager.isLocalConnected()) {
                        this.myIcon = CloudConfigIcons.Not_connected;
                        this.myTooltip = CloudConfigBundle.message("login.message", new Object[0]);
                        break;
                    }
                }
                case OFFLINE: {
                    if (manager.isOfflineWithJBA()) {
                        this.myIcon = CloudConfigIcons.Not_connected;
                        this.myTooltip = CloudConfigBundle.message("offline.message", new Object[0]);
                        break;
                    }
                }
                case DISABLED: {
                    this.myStatusBar.removeWidget(StatusBarInfoManager.ID);
                    return;
                }
                case JBA_IO_ERROR: {
                    this.myIcon = CloudConfigIcons.Io_error;
                    if (manager.getErrorMessage() == null) {
                        this.myTooltip = CloudConfigBundle.message("error.connected.message", new Object[0]);
                        break;
                    }
                    this.myTooltip = CloudConfigBundle.message("error.connected.full.message", manager.getErrorMessage());
                    break;
                }
                case JBA_NOT_ACCEPTED: {
                    this.myIcon = CloudConfigIcons.Not_connected;
                    this.myTooltip = CloudConfigBundle.message("not.accepted.message", new Object[0]);
                    this.createNotAcceptedActions();
                    break;
                }
                case JBA_IO_OPERATION: {
                    this.myIcon = CloudConfigIcons.Io_operation;
                    this.myTooltip = CloudConfigBundle.message("io.operation.message", new Object[0]);
                    break;
                }
                case JBA_NOT_CONNECTED: 
                case JBA_THIS_NOT_CONNECTED: {
                    this.myIcon = CloudConfigIcons.Not_connected;
                    this.myTooltip = CloudConfigBundle.message("not.connected.message", new Object[0]);
                    this.createNotConnectedActions();
                    break;
                }
                case JBA_CONNECTED: {
                    if (manager.hasPluginsUpdate() || manager.hasUpdateApi()) {
                        this.myIcon = CloudConfigIcons.Update;
                        this.myTooltip = CloudConfigBundle.message(manager.hasUpdateApi() ? "update.api.message" : "update.plugins.message", new Object[0]);
                    } else {
                        this.myIcon = CloudConfigIcons.Connected;
                        this.myTooltip = CloudConfigBundle.message("connected.message", new Object[0]);
                    }
                    this.createConnectedActions();
                }
            }
            this.myStatusBar.updateWidget(StatusBarInfoManager.ID);
        }

        private void createNotConnectedActions() {
            this.myActions = new DefaultActionGroup();
            this.myPopupTitle = CloudConfigBundle.message("not.connected.popup.title", new Object[0]);
            this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("enable.cloud.action", new Object[0])){

                public void actionPerformed(AnActionEvent e) {
                    StatusBarInfoManager.connectInstance(EmptyRunnable.INSTANCE);
                }
            });
            this.createHideAction();
        }

        private void createHideAction() {
            this.myActions.addSeparator();
            this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("hide.cloud.action", new Object[0])){

                public void actionPerformed(AnActionEvent e) {
                    CloudConfigManager.getInstance().disable();
                }
            });
        }

        private void createConnectedActions() {
            this.myActions = new DefaultActionGroup();
            this.myPopupBottomTitle = CloudConfigBundle.message("connected.popup.bottom.title", CloudConfigClientUtil.getUserLogin());
            CloudConfigManager manager = CloudConfigManager.getInstance();
            this.myPopupTitle = CloudConfigBundle.message(manager.hasPluginsUpdate() ? "plugins.popup.title" : "connected.popup.title", new Object[0]);
            if (manager.hasUpdateApi()) {
                this.myActions.add((AnAction)new MyUpdateApiAction());
            }
            if (manager.hasPluginsUpdate() || manager.hasPluginsAnyUpdate()) {
                this.myActions.addAction((AnAction)new MyPluginsAction());
            }
            this.myActions.add((AnAction)new MyToggleAction());
            this.myActions.addSeparator();
            this.myActions.addAction((AnAction)new MyDisableAction());
        }

        private void createNotAcceptedActions() {
            this.myActions = new DefaultActionGroup();
            this.myPopupTitle = CloudConfigBundle.message("not.connected.popup.title", new Object[0]);
            this.createHideAction();
        }

        public void dispose() {
            this.myStatusBar = null;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                InfoComponent.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @Nullable
        public String getTooltipText() {
            return this.myTooltip;
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return event -> {
                CloudConfigManager manager = CloudConfigManager.getInstance();
                StatusInfo state = manager.getStatusInfo();
                if (this.myActions == null) {
                    if (state == StatusInfo.JBA_IO_ERROR) {
                        manager.updateIO(StatusBarInfoManager.showPopupMessage(this.myStatusBar.getFrame().getProject()));
                    } else if (state == StatusInfo.OFFLINE) {
                        StatusBarInfoManager.showOfflineMessage();
                    } else if (state == StatusInfo.JBA_NOT_FOUND) {
                        StatusBarInfoManager.showLoginMessage();
                    }
                } else {
                    final Component component = event.getComponent();
                    final ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("  " + this.myPopupTitle + "  ", (ActionGroup)this.myActions, DataManager.getInstance().getDataContext(component), false, null, this.myActions.getChildrenCount());
                    if (this.myPopupBottomTitle != null) {
                        popup.setAdText(this.myPopupBottomTitle, 0);
                    }
                    popup.addListener(new JBPopupListener(){
                        String myIconTooltip;

                        public void beforeShown(LightweightWindowEvent event) {
                            this.myIconTooltip = myTooltip;
                            myTooltip = null;
                            Point location = component.getLocationOnScreen();
                            Dimension size = popup.getSize();
                            popup.setLocation(new Point(location.x + component.getWidth() - size.width, location.y - size.height));
                        }

                        public void onClosed(LightweightWindowEvent event) {
                            myTooltip = this.myIconTooltip;
                        }
                    });
                    popup.show(component);
                }
            };
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
            if (type == null) {
                InfoComponent.$$$reportNull$$$0(2);
            }
            return this;
        }

        @NotNull
        public String ID() {
            if (StatusBarInfoManager.ID == null) {
                InfoComponent.$$$reportNull$$$0(3);
            }
            return StatusBarInfoManager.ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ID";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "install";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyUpdateApiAction
    extends DumbAwareAction {
        public MyUpdateApiAction() {
            super(CloudConfigBundle.message("update.api.action", new Object[0]));
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected() && CloudConfigManager.getInstance().hasUpdateApi());
        }

        public void actionPerformed(AnActionEvent e) {
            StatusBarInfoManager.showUpdateApiDialog();
        }
    }

    public static class MyDisableAction
    extends DumbAwareAction {
        public MyDisableAction() {
            super(CloudConfigBundle.message("disable.cloud.action", new Object[0]));
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected());
        }

        public void actionPerformed(AnActionEvent e) {
            Boolean result = MyMessages.showDialog("disconnect.message", "disconnect.button", "disconnect.remove.data");
            if (result != null) {
                CloudConfigManager.getInstance().disconnect(result);
            }
        }
    }

    public static class MyPluginsAction
    extends DumbAwareAction {
        public MyPluginsAction() {
            super(CloudConfigBundle.message("update.plugins.action", new Object[0]));
        }

        public void update(AnActionEvent e) {
            CloudConfigManager manager = CloudConfigManager.getInstance();
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected() && (manager.hasPluginsUpdate() || manager.hasPluginsAnyUpdate()));
        }

        public void actionPerformed(AnActionEvent e) {
            MyMessages.showPluginsDialog();
        }
    }

    public static class MyToggleAction
    extends ToggleAction
    implements DumbAware {
        public MyToggleAction() {
            super(CloudConfigBundle.message("plugins.auto.update", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected());
        }

        public boolean isSelected(AnActionEvent e) {
            return CloudConfigManager.getInstance().isAutoUpdatePlugins();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            CloudConfigManager.getInstance().setAutoUpdatePlugins(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/StatusBarInfoManager$MyToggleAction", "update"));
        }
    }

    public static class MenuAction
    extends DumbAwareAction {
        public void update(AnActionEvent e) {
            CloudConfigManager manager = CloudConfigManager.getInstance();
            StatusInfo state = manager.getStatusInfo();
            boolean value = state.in(StatusInfo.OFFLINE, StatusInfo.JBA_THIS_NOT_CONNECTED);
            if (state == StatusInfo.JBA_IO_ERROR && manager.isConnectedState()) {
                value = false;
            }
            e.getPresentation().setEnabledAndVisible(value);
        }

        public void actionPerformed(AnActionEvent e) {
            CloudConfigManager manager = CloudConfigManager.getInstance();
            StatusInfo state = manager.getStatusInfo();
            if (state == StatusInfo.JBA_NOT_FOUND) {
                StatusBarInfoManager.showLoginMessage();
                return;
            }
            if (state == StatusInfo.OFFLINE) {
                StatusBarInfoManager.showOfflineMessage();
                return;
            }
            if (state == StatusInfo.DISABLED || state == StatusInfo.JBA_IO_ERROR) {
                manager.recalculateInitStatus(e.getProject());
            }
            if (manager.getStatusInfo() == StatusInfo.JBA_IO_ERROR) {
                StatusBarInfoManager.showErrorMessage(manager.getErrorMessage());
            } else {
                StatusBarInfoManager.connectInstance(StatusBarInfoManager.showPopupMessage(e.getProject()));
            }
        }
    }

    public static class MenuGroup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected());
        }
    }

    public static class MyStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() && CloudConfigManager.getInstance().getStatusInfo().notDisabled()) {
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                StatusBarWidget widget = statusBar.getWidget(StatusBarInfoManager.ID);
                if (widget == null) {
                    statusBar.addWidget((StatusBarWidget)new InfoComponent());
                    CloudConfigManager.LOG.info("=== StatusBar.start create ===");
                } else {
                    CloudConfigManager.LOG.info("=== StatusBar.start another widget: " + widget + " ===");
                }
            } else {
                CloudConfigManager.LOG.info("=== StatusBar ignored ===");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cloudConfig/StatusBarInfoManager$MyStartupActivity", "runActivity"));
        }
    }
}

