/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.model.LibraryBundlificationRule;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;

@State(name="Osmorc", storages={@Storage(value="osmorc.xml")})
public class ApplicationSettings
implements PersistentStateComponent<ApplicationSettings> {
    private List<FrameworkInstanceDefinition> myInstances = ContainerUtil.newArrayList();
    private List<FrameworkInstanceDefinition> myActiveInstances = null;
    private List<LibraryBundlificationRule> myRules = ContainerUtil.newArrayList((Object[])new LibraryBundlificationRule[]{new LibraryBundlificationRule()});

    public static ApplicationSettings getInstance() {
        return (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
    }

    public ApplicationSettings getState() {
        return this;
    }

    public void loadState(ApplicationSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @AbstractCollection(elementTag="frameworkDefinition")
    public List<FrameworkInstanceDefinition> getFrameworkInstanceDefinitions() {
        return this.myInstances;
    }

    public void setFrameworkInstanceDefinitions(List<FrameworkInstanceDefinition> instances) {
        this.myInstances = instances;
        this.myActiveInstances = null;
    }

    @AbstractCollection(elementTag="libraryBundlificationRule")
    public List<LibraryBundlificationRule> getLibraryBundlificationRules() {
        return this.myRules;
    }

    public void setLibraryBundlificationRules(List<LibraryBundlificationRule> rules) {
        this.myRules = rules;
        if (this.myRules == null || this.myRules.isEmpty()) {
            this.myRules = ContainerUtil.newArrayList((Object[])new LibraryBundlificationRule[]{new LibraryBundlificationRule()});
        }
    }

    @Nullable
    public FrameworkInstanceDefinition getFrameworkInstance(@Nullable String name) {
        if (name != null) {
            for (FrameworkInstanceDefinition frameworkInstanceDefinition : this.myInstances) {
                if (!name.equals(frameworkInstanceDefinition.getName())) continue;
                return frameworkInstanceDefinition;
            }
        }
        return null;
    }

    @NotNull
    public List<FrameworkInstanceDefinition> getActiveFrameworkInstanceDefinitions() {
        if (this.myActiveInstances == null) {
            FrameworkIntegratorRegistry registry = FrameworkIntegratorRegistry.getInstance();
            this.myActiveInstances = ContainerUtil.filter(this.myInstances, definition -> registry.findIntegratorByInstanceDefinition((FrameworkInstanceDefinition)((Object)definition)) != null);
        }
        List<FrameworkInstanceDefinition> list = this.myActiveInstances;
        if (list == null) {
            ApplicationSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/ApplicationSettings", "getActiveFrameworkInstanceDefinitions"));
    }
}

