/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.maven.facet;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Instruction;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.osmorc.maven.facet.DependencyEmbedderException;

public abstract class AbstractDependencyFilter {
    private static final Pattern MISSING_KEY_PATTERN = Pattern.compile("(^|,)\\p{Blank}*(!)?\\p{Blank}*([a-zA-Z]+=)");
    private final Collection<MavenArtifact> m_dependencyArtifacts;

    public AbstractDependencyFilter(Collection<MavenArtifact> dependencyArtifacts) {
        this.m_dependencyArtifacts = dependencyArtifacts;
    }

    protected final void processInstructions(String header) throws DependencyEmbedderException {
        Parameters instructions = OSGiHeader.parseHeader((String)MISSING_KEY_PATTERN.matcher(header).replaceAll("$1$2*;$3"));
        LinkedHashSet<MavenArtifact> availableDependencies = new LinkedHashSet<MavenArtifact>(this.m_dependencyArtifacts);
        Iterator clauseIterator = instructions.entrySet().iterator();
        while (clauseIterator.hasNext()) {
            DependencyFilter filter;
            String inline = "false";
            LinkedHashSet<MavenArtifact> filteredDependencies = new LinkedHashSet<MavenArtifact>(availableDependencies);
            Map.Entry clause = (Map.Entry)clauseIterator.next();
            String primaryKey = ((String)clause.getKey()).replaceFirst("~+$", "");
            boolean isNegative = primaryKey.startsWith("!");
            if (isNegative) {
                primaryKey = primaryKey.substring(1);
            }
            if (!"*".equals(primaryKey)) {
                filter = new DependencyFilter(primaryKey){

                    @Override
                    boolean matches(MavenArtifact dependency) {
                        return super.matches(dependency.getArtifactId());
                    }
                };
                filter.filter(filteredDependencies);
            }
            for (Map.Entry entry : ((Attrs)clause.getValue()).entrySet()) {
                Map.Entry attr = entry;
                if ("groupId".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        @Override
                        boolean matches(MavenArtifact dependency) {
                            return super.matches(dependency.getGroupId());
                        }
                    };
                } else if ("artifactId".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        @Override
                        boolean matches(MavenArtifact dependency) {
                            return super.matches(dependency.getArtifactId());
                        }
                    };
                } else if ("version".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        @Override
                        boolean matches(MavenArtifact dependency) {
                            try {
                                return super.matches(dependency.getVersion());
                            }
                            catch (Exception e) {
                                return super.matches(dependency.getVersion());
                            }
                        }
                    };
                } else if ("scope".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "compile"){

                        @Override
                        boolean matches(MavenArtifact dependency) {
                            return super.matches(dependency.getScope());
                        }
                    };
                } else if ("type".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "jar"){

                        @Override
                        boolean matches(MavenArtifact dependency) {
                            return super.matches(dependency.getType());
                        }
                    };
                } else if ("classifier".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        @Override
                        boolean matches(MavenArtifact dependency) {
                            return super.matches(dependency.getClassifier());
                        }
                    };
                } else if ("optional".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "false"){

                        @Override
                        boolean matches(MavenArtifact dependency) {
                            return super.matches(String.valueOf(dependency.isOptional()));
                        }
                    };
                } else {
                    if ("inline".equals(attr.getKey())) {
                        inline = (String)attr.getValue();
                        continue;
                    }
                    throw new DependencyEmbedderException("Unexpected attribute " + attr.getKey());
                }
                filter.filter(filteredDependencies);
            }
            if (isNegative) {
                availableDependencies.removeAll(filteredDependencies);
                if (clauseIterator.hasNext()) continue;
                this.processDependencies(availableDependencies, inline);
                continue;
            }
            this.processDependencies(filteredDependencies, inline);
        }
    }

    protected abstract void processDependencies(Collection<MavenArtifact> var1, String var2);

    private static abstract class DependencyFilter {
        private final Instruction m_instruction;
        private final String m_defaultValue;

        public DependencyFilter(String expression) {
            this(expression, "");
        }

        public DependencyFilter(String expression, String defaultValue) {
            this.m_instruction = new Instruction(expression);
            this.m_defaultValue = defaultValue;
        }

        public void filter(Collection<MavenArtifact> dependencies) {
            Iterator<MavenArtifact> i = dependencies.iterator();
            while (i.hasNext()) {
                if (this.matches(i.next())) continue;
                i.remove();
            }
        }

        abstract boolean matches(MavenArtifact var1);

        boolean matches(String text) {
            boolean result = null == text ? this.m_instruction.matches(this.m_defaultValue) : this.m_instruction.matches(text);
            return this.m_instruction.isNegated() ? !result : result;
        }
    }
}

