/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.osmorc.i18n.OsmorcBundle;

public class ViewManifestAction
extends AnAction
implements DumbAware {
    private final String myJarFilePath;

    public ViewManifestAction(String title, String jarFilePath) {
        this.myJarFilePath = jarFilePath;
        this.getTemplatePresentation().setText(title);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ViewManifestAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        VirtualFile jarFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myJarFilePath);
        if (jarFile == null) {
            String title = OsmorcBundle.message("view.manifest.title", new Object[0]);
            String message = OsmorcBundle.message("view.manifest.no.jar", new Object[0]);
            OsmorcBundle.notification(title, message, NotificationType.WARNING).notify(project);
            return;
        }
        String manifestPath = jarFile.getPath() + "!/" + "META-INF/MANIFEST.MF";
        VirtualFile manifestFile = JarFileSystem.getInstance().refreshAndFindFileByPath(manifestPath);
        if (manifestFile == null) {
            String title = OsmorcBundle.message("view.manifest.title", new Object[0]);
            String message = OsmorcBundle.message("view.manifest.missing", new Object[0]);
            OsmorcBundle.notification(title, message, NotificationType.WARNING).notify(project);
            return;
        }
        new OpenFileDescriptor(project, manifestFile).navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/osmorc/make/ViewManifestAction", "actionPerformed"));
    }
}

