/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.project;

import aQute.lib.utf8properties.UTF8Properties;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.osgi.project.BundleManifest;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;

public class BundleManifestCache {
    private final Project myProject;
    private final ProjectFileIndex myIndex;
    private final CachedValuesManager myManager;
    private final Map<Object, CachedValue<BundleManifest>> myCache;

    public static BundleManifestCache getInstance(@NotNull Project project) {
        if (project == null) {
            BundleManifestCache.$$$reportNull$$$0(0);
        }
        return (BundleManifestCache)ServiceManager.getService((Project)project, BundleManifestCache.class);
    }

    public BundleManifestCache(@NotNull Project project, @NotNull ProjectFileIndex index, @NotNull CachedValuesManager manager) {
        if (project == null) {
            BundleManifestCache.$$$reportNull$$$0(1);
        }
        if (index == null) {
            BundleManifestCache.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            BundleManifestCache.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myIndex = index;
        this.myManager = manager;
        this.myCache = Collections.synchronizedMap(ContainerUtil.createSoftMap());
    }

    @Nullable
    public BundleManifest getManifest(@NotNull PsiClass psiClass) {
        PsiFile classOwner;
        if (psiClass == null) {
            BundleManifestCache.$$$reportNull$$$0(4);
        }
        return (classOwner = psiClass.getContainingFile()) != null ? this.getManifest((PsiFileSystemItem)classOwner) : null;
    }

    @Nullable
    public BundleManifest getManifest(@NotNull PsiFileSystemItem item) {
        VirtualFile file;
        if (item == null) {
            BundleManifestCache.$$$reportNull$$$0(5);
        }
        if ((file = item.getVirtualFile()) != null) {
            List entries = this.myIndex.getOrderEntriesForFile(file);
            if (entries.size() == 1 && entries.get(0) instanceof JdkOrderEntry) {
                return new JdkBundleManifest();
            }
            Module module = this.myIndex.getModuleForFile(file);
            if (module != null) {
                return this.getManifest(module);
            }
            VirtualFile libRoot = this.myIndex.getClassRootForFile(file);
            if (libRoot != null) {
                return this.getManifest(libRoot);
            }
        }
        return null;
    }

    @Nullable
    public BundleManifest getManifest(@NotNull Module module) {
        OsmorcFacet facet;
        if (module == null) {
            BundleManifestCache.$$$reportNull$$$0(6);
        }
        if ((facet = OsmorcFacet.getInstance(module)) == null) {
            return null;
        }
        CachedValue value = this.myCache.get((Object)facet);
        if (value == null) {
            value = this.myManager.createCachedValue(() -> {
                OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)facet.getConfiguration();
                BundleManifest manifest = null;
                List dependencies = ContainerUtil.newSmartList((Object)configuration);
                switch (configuration.getManifestGenerationMode()) {
                    case Manually: {
                        PsiFile manifestFile = BundleManifestCache.findInModuleRoots(facet.getModule(), configuration.getManifestLocation());
                        if (manifestFile instanceof ManifestFile) {
                            manifest = BundleManifestCache.readManifest((ManifestFile)manifestFile);
                            dependencies.add(manifestFile);
                            break;
                        }
                        dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
                        break;
                    }
                    case OsmorcControlled: {
                        HashMap map = ContainerUtil.newHashMap(configuration.getAdditionalPropertiesAsMap());
                        map.put("Bundle-SymbolicName", configuration.getBundleSymbolicName());
                        map.put("Bundle-Version", configuration.getBundleVersion());
                        map.put("Bundle-Activator", configuration.getBundleActivator());
                        manifest = new BundleManifest(map);
                        break;
                    }
                    case Bnd: {
                        PsiFile bndFile = BundleManifestCache.findInModuleRoots(facet.getModule(), configuration.getBndFileLocation());
                        if (bndFile != null) {
                            manifest = BundleManifestCache.readProperties(bndFile);
                            dependencies.add(bndFile);
                            break;
                        }
                        dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
                        break;
                    }
                }
                return CachedValueProvider.Result.create(manifest, (Collection)dependencies);
            }, false);
            this.myCache.put((Object)facet, (CachedValue<BundleManifest>)value);
        }
        return (BundleManifest)value.getValue();
    }

    @Nullable
    public BundleManifest getManifest(@NotNull VirtualFile libRoot) {
        CachedValue value;
        if (libRoot == null) {
            BundleManifestCache.$$$reportNull$$$0(7);
        }
        if ((value = this.myCache.get(libRoot)) == null) {
            value = this.myManager.createCachedValue(() -> {
                VirtualFile manifestFile;
                if (libRoot == null) {
                    BundleManifestCache.$$$reportNull$$$0(8);
                }
                PsiFile psiFile = (manifestFile = libRoot.findFileByRelativePath("META-INF/MANIFEST.MF")) != null ? PsiManager.getInstance((Project)this.myProject).findFile(manifestFile) : null;
                BundleManifest manifest = psiFile instanceof ManifestFile ? BundleManifestCache.readManifest((ManifestFile)psiFile) : null;
                return CachedValueProvider.Result.createSingleDependency((Object)manifest, (Object)libRoot);
            }, false);
            this.myCache.put(libRoot, (CachedValue<BundleManifest>)value);
        }
        return (BundleManifest)value.getValue();
    }

    private static PsiFile findInModuleRoots(Module module, String path) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile file = root.findFileByRelativePath(path);
            if (file == null) continue;
            return PsiManager.getInstance((Project)module.getProject()).findFile(file);
        }
        return null;
    }

    private static BundleManifest readManifest(ManifestFile manifestFile) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(manifestFile.getText().getBytes("UTF-8"));
            Attributes attributes = new Manifest(stream).getMainAttributes();
            HashMap map = ContainerUtil.newHashMap();
            for (Object key : attributes.keySet()) {
                String name = key.toString();
                map.put(name, attributes.getValue(name));
            }
            return new BundleManifest(map, (PsiFile)manifestFile);
        }
        catch (IOException iOException) {
        }
        catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
            // empty catch block
        }
        return null;
    }

    private static BundleManifest readProperties(PsiFile propertiesFile) {
        try {
            VirtualFile file;
            UTF8Properties properties = new UTF8Properties();
            properties.load((Reader)new StringReader(propertiesFile.getText()));
            HashMap map = ContainerUtil.newHashMap();
            for (Object key : properties.keySet()) {
                String name = key.toString();
                map.put(name, properties.getProperty(name));
            }
            if (map.get("Bundle-SymbolicName") == null && (file = propertiesFile.getVirtualFile()) != null) {
                if (!"bnd.bnd".equals(file.getName())) {
                    map.put("Bundle-SymbolicName", FileUtil.getNameWithoutExtension((String)file.getName()));
                } else if (file.getParent() != null) {
                    map.put("Bundle-SymbolicName", file.getParent().getName());
                }
            }
            return new BundleManifest(map, propertiesFile);
        }
        catch (IOException iOException) {
        }
        catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libRoot";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/osgi/project/BundleManifestCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getManifest";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getManifest$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JdkBundleManifest
    extends BundleManifest {
        public JdkBundleManifest() {
            super(Collections.emptyMap());
        }

        @Override
        public String getBundleSymbolicName() {
            return "";
        }

        @Override
        public String getExportedPackage(@NotNull String packageName) {
            if (packageName == null) {
                JdkBundleManifest.$$$reportNull$$$0(0);
            }
            return packageName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/osgi/project/BundleManifestCache$JdkBundleManifest", "getExportedPackage"));
        }
    }
}

