/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.resolve;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.OsmorcIdeaIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;

public class ResolveConfirm {
    private JPanel myContentPane;
    private JBList<Resource> myRequiredResources;
    private Tree myReason;
    private static final Icon OSGI_BUNDLE_ICON;

    public ResolveConfirm(Map<Resource, List<Wire>> resolveResult) {
        this.$$$setupUI$$$();
        DefaultListModel requiredResourcesModel = new DefaultListModel();
        resolveResult.keySet().stream().sorted().forEach(requiredResourcesModel::addElement);
        DefaultTreeModel reasonModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myReason.setModel((TreeModel)reasonModel);
        this.myRequiredResources.setModel(requiredResourcesModel);
        this.myRequiredResources.addListSelectionListener(event -> {
            Resource selectedResource = (Resource)this.myRequiredResources.getSelectedValue();
            ResolveConfirm.updateReasonModel(resolveResult, reasonModel, selectedResource);
        });
        this.myRequiredResources.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Resource>(){

            protected void customizeCellRenderer(@NotNull JList list, Resource resource, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setIcon(OSGI_BUNDLE_ICON);
                List capabilities = resource.getCapabilities("osgi.identity");
                if (capabilities.size() == 1) {
                    Capability capability = (Capability)capabilities.get(0);
                    String identity = Objects.toString(capability.getAttributes().get("osgi.identity"));
                    Object version = capability.getAttributes().get("version");
                    this.append(identity, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                    if (version != null) {
                        this.append(", version ", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                        this.append(version.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                    }
                } else {
                    this.append(resource.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/osgi/bnd/resolve/ResolveConfirm$1", "customizeCellRenderer"));
            }
        });
        this.myReason.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object userObject;
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof Capability) {
                    Capability capability = (Capability)userObject;
                    String identity = Objects.toString(capability.getAttributes().get(capability.getNamespace()));
                    Object version = capability.getAttributes().get("version");
                    this.append(((Capability)userObject).getNamespace(), SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                    this.append("=", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                    this.append(identity, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                    if (version != null) {
                        this.append(", version ", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                        this.append(version.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                    }
                    switch (capability.getNamespace()) {
                        case "osgi.wiring.package": {
                            this.setIcon(AllIcons.Nodes.Package);
                            break;
                        }
                        case "osgi.identity": {
                            this.setIcon(OSGI_BUNDLE_ICON);
                            break;
                        }
                        case "osgi.contract": 
                        case "osgi.implementation": 
                        case "osgi.extender": 
                        case "osgi.service": {
                            this.setIcon(OsmorcIdeaIcons.Osgi);
                        }
                    }
                } else if (userObject instanceof Resource) {
                    Resource resource = (Resource)userObject;
                    this.setIcon(null);
                    List list = resource.getCapabilities("osgi.identity");
                    if (list.size() == 1) {
                        Capability capability = (Capability)list.get(0);
                        String identity = Objects.toString(capability.getAttributes().get("osgi.identity"));
                        Object version = capability.getAttributes().get("version");
                        this.append("REQUIRED BY: ", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                        this.append(identity, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                        if (version != null) {
                            this.append(", version ", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                            this.append(version.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                        }
                    } else {
                        this.append("REQUIRED BY: " + resource.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                    }
                } else {
                    this.setIcon(null);
                    this.append(Objects.toString(userObject), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/osgi/bnd/resolve/ResolveConfirm$2", "customizeCellRenderer"));
            }
        });
    }

    private static void updateReasonModel(Map<Resource, List<Wire>> resolve, DefaultTreeModel reasonModel, Resource selectedResource) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        if (selectedResource != null) {
            ResolveConfirm.addRequirer(root, selectedResource, resolve);
        }
        reasonModel.setRoot(root);
    }

    private static void addRequirer(DefaultMutableTreeNode root, Resource resource, Map<Resource, List<Wire>> resolve) {
        List<Wire> wires = resolve.get(resource);
        if (wires == null) {
            return;
        }
        HashMap map = new HashMap();
        wires.forEach(wire -> {
            DefaultMutableTreeNode requirement = map.computeIfAbsent(wire.getCapability(), DefaultMutableTreeNode::new);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(wire.getRequirer());
            requirement.add(child);
            ResolveConfirm.addRequirer(child, wire.getRequirer(), resolve);
        });
        map.values().forEach(root::add);
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    static {
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(AllIcons.Nodes.PpLib, 0);
        Icon osgiSmall = new LayeredIcon(new Icon[]{OsmorcIdeaIcons.Osgi}).scale(0.5f);
        icon.setIcon(osgiSmall, 1, 4);
        OSGI_BUNDLE_ICON = icon;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree;
        JBList jBList;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(2, 2, 2, 2), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(600, 500));
        jPanel.setRequestFocusEnabled(true);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(280);
        jSplitPane.setDividerSize(9);
        jSplitPane.setOrientation(0);
        jPanel.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel2);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myRequiredResources = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JLabel jLabel = new JLabel();
        jLabel.setText("Required resources");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel3);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myReason = tree = new Tree();
        tree.setRootVisible(false);
        jBScrollPane2.setViewportView((Component)tree);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Reasons");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

