/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.imp;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.ContainerUtil;
import icons.OsmorcIdeaIcons;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.bnd.imp.BndProjectImporter;

public class BndProjectImportBuilder
extends ProjectImportBuilder<Project> {
    private Workspace myWorkspace = null;
    private List<Project> myProjects = null;
    private Set<Project> myChosenProjects = null;
    private boolean myOpenProjectSettings = false;

    @NotNull
    public String getName() {
        if ("Bnd/Bndtools" == null) {
            BndProjectImportBuilder.$$$reportNull$$$0(0);
        }
        return "Bnd/Bndtools";
    }

    public Icon getIcon() {
        return OsmorcIdeaIcons.Bnd;
    }

    public Workspace getWorkspace() {
        return this.myWorkspace;
    }

    public void setWorkspace(Workspace workspace, Collection<Project> projects) {
        this.myWorkspace = workspace;
        this.myProjects = ContainerUtil.newArrayList(projects);
    }

    public List<Project> getList() {
        return this.myProjects;
    }

    public void setList(List<Project> list) throws ConfigurationException {
        this.myChosenProjects = ContainerUtil.newHashSet(list);
    }

    public boolean isMarked(Project project) {
        return this.myChosenProjects == null || this.myChosenProjects.contains(project);
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.myOpenProjectSettings;
    }

    public void setOpenProjectSettingsAfter(boolean openProjectSettings) {
        this.myOpenProjectSettings = openProjectSettings;
    }

    @NotNull
    public List<Module> commit(com.intellij.openapi.project.Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        if (model == null) {
            List<Module> list;
            model = ModuleManager.getInstance((com.intellij.openapi.project.Project)project).getModifiableModel();
            try {
                List<Module> result = this.commit(project, model, modulesProvider, artifactModel);
                WriteAction.run(() -> ((ModifiableModuleModel)model).commit());
                list = result;
            }
            catch (Error | RuntimeException e) {
                model.dispose();
                throw e;
            }
            if (list == null) {
                BndProjectImportBuilder.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (this.myWorkspace != null) {
            List toImport = ContainerUtil.filter(this.myProjects, project1 -> this.isMarked((Project)project1));
            BndProjectImporter importer = new BndProjectImporter(project, this.myWorkspace, toImport);
            Module rootModule = importer.createRootModule(model);
            importer.setupProject();
            StartupManager.getInstance((com.intellij.openapi.project.Project)project).registerPostStartupActivity(() -> importer.resolve(false));
            List<Module> list = Collections.singletonList(rootModule);
            if (list == null) {
                BndProjectImportBuilder.$$$reportNull$$$0(2);
            }
            return list;
        }
        File file = new File(this.getFileToImport());
        if ("bnd.bnd".equals(file.getName())) {
            file = file.getParentFile();
        }
        BndProjectImporter.reimportProjects(project, Collections.singleton(file.getPath()));
        List<Module> list = Collections.emptyList();
        if (list == null) {
            BndProjectImportBuilder.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void cleanup() {
        this.myWorkspace = null;
        this.myProjects = null;
        this.myChosenProjects = null;
        super.cleanup();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/osgi/bnd/imp/BndProjectImportBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

