/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.maven.dependencies.MavenManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianExistLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfigurationCoordinator;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianTestFrameworkRunConfiguration;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;

public abstract class ArquillianRunConfigurationType
implements ConfigurationType {
    static {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        messageBus.connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarting(@NotNull String executorId, final @NotNull ExecutionEnvironment env) {
                ArquillianRunConfiguration arquillianRunConfiguration;
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                RunProfile runProfile = env.getRunProfile();
                while (runProfile instanceof WrappingRunConfiguration) {
                    runProfile = ((WrappingRunConfiguration)runProfile).getPeer();
                }
                if (!(runProfile instanceof ArquillianTestFrameworkRunConfiguration)) {
                    return;
                }
                ArquillianRunConfigurationCoordinator coordinator = new ArquillianRunConfigurationCoordinator(env.getProject());
                ArquillianContainerState containerState = coordinator.getContainerState(arquillianRunConfiguration = ((ArquillianTestFrameworkRunConfiguration)runProfile).getRunConfiguration());
                if (containerState == null) {
                    throw new ProcessCanceledException();
                }
                if (JarRepositoryManager.hasRunningTasks()) {
                    ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)env.getExecutor().getToolWindowId(), (RunProfile)env.getRunProfile(), (ExecutionException)new ExecutionException(ArquillianBundle.message("arquillian.run.failed.due.to.maven.activity", new Object[0])));
                    throw new ProcessCanceledException();
                }
                for (ArquillianLibraryState library : containerState.libraries) {
                    final RunProfile finalRunProfile = runProfile;
                    library.accept(new ArquillianLibraryState.Visitor<Void>(){

                        @Override
                        public Void visitMavenLibrary(ArquillianMavenLibraryState state) {
                            try {
                                MavenManager.getInstance().getOrLoadMavenArtifactJars(env.getProject(), state.groupId, state.artifactId, state.version, state.downloadSources, state.downloadJavaDocs);
                            }
                            catch (ExecutionException e) {
                                ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)env.getExecutor().getToolWindowId(), (RunProfile)finalRunProfile, (ExecutionException)e);
                                throw new ProcessCanceledException((Throwable)e);
                            }
                            return null;
                        }

                        @Override
                        public Void visitExistLibrary(ArquillianExistLibraryState state) {
                            return null;
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executorId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "env";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianRunConfigurationType$1";
                objectArray[2] = "processStarting";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

