/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.model;

import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianListenersHolder;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianModelCreator;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianListState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianState;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class ArquillianListModel<ChildState extends ArquillianState, ChildModel extends ArquillianModel<ChildState, ChildModel>, State extends ArquillianListState<ChildState>, Model extends ArquillianListModel<ChildState, ChildModel, State, Model>>
extends ArquillianModel<State, Model> {
    protected final ArquillianModelCreator<ChildState, ChildModel> childModelCreator;
    ArquillianListenersHolder<Listener<ChildState, ChildModel>> listListenersHolder = new ArquillianListenersHolder();
    private List<ChildModel> children;
    private HashMap<ChildModel, ArquillianListenersHolder.ListenerRemover> listenerRemovers = new HashMap();

    public ArquillianListenersHolder<Listener<ChildState, ChildModel>> getListListenersHolder() {
        return this.listListenersHolder;
    }

    public ArquillianListModel(State state, ArquillianModelCreator<ChildState, ChildModel> childModelCreator) {
        this.childModelCreator = childModelCreator;
        this.children = new ArrayList<ChildModel>(JBIterable.from(state.getChildren()).transform(childModelCreator::createModel).toList());
    }

    @Override
    public boolean hasChanges(State state) {
        if (state.getChildren().size() != this.children.size()) {
            return true;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ArquillianState childState;
            ArquillianModel childModel = (ArquillianModel)this.children.get(i);
            if (!childModel.hasChanges(childState = (ArquillianState)state.getChildren().get(i))) continue;
            return true;
        }
        return false;
    }

    public void addItem(ChildModel childModel) {
        this.addItem(childModel, this.children.size());
    }

    public void addItem(ChildModel childModel, int index) {
        this.children.add(index, childModel);
        this.listListenersHolder.notifyListeners(listener -> listener.itemAdded(childModel, index));
        this.notifyMeChanged();
        this.listenerRemovers.put(childModel, ((ArquillianModel)childModel).addChangeListener(new ArquillianModel.Listener<ChildState, ChildModel>((ArquillianModel)childModel){
            final /* synthetic */ ArquillianModel val$childModel;
            {
                this.val$childModel = arquillianModel;
            }

            @Override
            public void itemChanged(ChildModel model) {
                ArquillianListModel.this.listListenersHolder.notifyListeners(listener -> listener.itemChanged(this.val$childModel));
                ArquillianListModel.this.notifyMeChanged();
            }
        }));
    }

    public void removeItem(ChildModel childModel) {
        int index = this.children.indexOf(childModel);
        if (index == -1) {
            return;
        }
        this.children.remove(childModel);
        ArquillianListenersHolder.ListenerRemover listenerRemover = this.listenerRemovers.remove(childModel);
        if (listenerRemover != null) {
            listenerRemover.close();
        }
        this.listListenersHolder.notifyListeners(listener -> listener.itemRemoved(childModel, index));
        this.notifyMeChanged();
    }

    public List<ChildModel> getChildren() {
        return this.children;
    }

    public List<ChildState> getChildrenStates() {
        return JBIterable.from(this.children).transform(ArquillianModel::getCurrentState).toList();
    }

    public ListModel createListModel() {
        return new ListModel(){
            private HashMap<ListDataListener, ArquillianListenersHolder.ListenerRemover> removers = new HashMap();

            @Override
            public int getSize() {
                return ArquillianListModel.this.getChildren().size();
            }

            public Object getElementAt(int index) {
                return ArquillianListModel.this.getChildren().get(index);
            }

            @Override
            public void addListDataListener(final ListDataListener l) {
                ArquillianListenersHolder.ListenerRemover remover = ArquillianListModel.this.getListListenersHolder().addListener(new Listener<ChildState, ChildModel>(){

                    @Override
                    public void itemAdded(ChildModel item, int index) {
                        l.intervalAdded(new ListDataEvent(item, 1, index, index));
                    }

                    @Override
                    public void itemRemoved(ChildModel item, int index) {
                        l.intervalRemoved(new ListDataEvent(item, 2, index, index));
                    }

                    @Override
                    public void itemChanged(ChildModel item) {
                        int index = ArquillianListModel.this.getChildren().indexOf(item);
                        l.contentsChanged(new ListDataEvent(item, 0, index, index));
                    }
                });
                this.removers.put(l, remover);
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
                ArquillianListenersHolder.ListenerRemover remover = this.removers.remove(l);
                if (remover != null) {
                    remover.close();
                }
            }
        };
    }

    public static interface Listener<ChildState extends ArquillianState, ChildModel extends ArquillianModel<ChildState, ChildModel>>
    extends ArquillianModel.Listener<ChildState, ChildModel> {
        public void itemAdded(ChildModel var1, int var2);

        public void itemRemoved(ChildModel var1, int var2);
    }
}

