/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.MethodBaseExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;

public class MethodReferenceExpr
extends MethodBaseExpr {
    MethodReferenceExpr(Expr parent, String name) {
        super(parent, name);
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return modelAnalyzer.findClass(Object.class);
    }

    @Override
    protected String computeUniqueKey() {
        return MethodReferenceExpr.join(this.getTarget(), "::", this.mName);
    }

    @Override
    public String getInvertibleError() {
        return "Listeners do not support two-way binding";
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
    }

    @Override
    public Expr resolveListeners(ModelClass listener, Expr parent) {
        try {
            return this.resolveListenersAsMethodReference(listener, parent);
        }
        catch (IllegalStateException e) {
            L.e("%s", e.getMessage());
            return this;
        }
    }

    @Override
    protected KCode generateCode() {
        Preconditions.check(false, "Cannot generate code for unresolved method reference %s", this);
        return null;
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        Preconditions.check(false, "Method references do not have an inverse", new Object[0]);
        return this;
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        Expr clonedTarget = this.getTarget().cloneToModel(model);
        return model.methodReference(clonedTarget, this.mName);
    }

    @Override
    public String toString() {
        return this.getTarget().toString() + "::" + this.mName;
    }
}

