/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class CastExpr
extends Expr {
    final String mType;

    CastExpr(String type, Expr expr) {
        super(expr);
        this.mType = type;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return modelAnalyzer.findClass(this.mType, this.getModel().getImports());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        return CastExpr.join("(", this.mType, ")", this.getCastExpr());
    }

    public Expr getCastExpr() {
        return this.getChildren().get(0);
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
        Expr castExpr = this.getCastExpr();
        if (castExpr.getResolvedType().isNullable() && !this.getResolvedType().isNullable()) {
            this.safeUnboxChild(model, castExpr);
        }
    }

    public String getCastType() {
        return this.getResolvedType().toJavaCode();
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app("((").app(this.getCastType()).app(") (", this.getCastExpr().toCode()).app("))");
    }

    @Override
    public String getInvertibleError() {
        return this.getCastExpr().getInvertibleError();
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        Expr castExpr = this.getCastExpr();
        ModelClass exprType = castExpr.getResolvedType();
        Expr castValue = model.castExpr(exprType.toJavaCode(), value);
        return castExpr.generateInverse(model, castValue, bindingClassName);
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.castExpr(this.mType, this.getCastExpr().cloneToModel(model));
    }

    @Override
    public String toString() {
        return "(" + this.mType + ") " + this.getCastExpr();
    }
}

