/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.BindingTarget;
import android.databinding.tool.expr.CallbackArgExpr;
import android.databinding.tool.expr.CallbackExprModel;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.FieldAccessExpr;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.store.Location;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import java.util.ArrayList;
import java.util.List;

public class InverseBinding
implements LocationScopeProvider {
    private final String mName;
    private final Expr mExpr;
    private final BindingTarget mTarget;
    private SetterStore.BindingGetterCall mGetterCall;
    private final ArrayList<FieldAccessExpr> mChainedExpressions = new ArrayList();
    private final CallbackExprModel mCallbackExprModel;
    private final Expr mInverseExpr;
    private final CallbackArgExpr mVariableExpr;
    private final ExecutionPath mExecutionPath;

    public InverseBinding(BindingTarget target, String name, Expr expr, String bindingClassName) {
        this.mTarget = target;
        this.mName = name;
        this.mCallbackExprModel = new CallbackExprModel(expr.getModel());
        this.mExpr = expr.cloneToModel(this.mCallbackExprModel).unwrapObservableField();
        this.mExpr.assertIsInvertible();
        this.setGetterCall(this.mExpr);
        this.mVariableExpr = this.mCallbackExprModel.callbackArg("callbackArg_0");
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        ModelClass type = modelAnalyzer.findClass(this.getGetterCall().getGetterType(), null);
        this.mVariableExpr.setClassFromCallback(type);
        this.mVariableExpr.setUserDefinedType(this.getGetterCall().getGetterType());
        this.mInverseExpr = this.mExpr.generateInverse(this.mCallbackExprModel, this.mVariableExpr, bindingClassName);
        this.mExecutionPath = ExecutionPath.createRoot();
        this.mInverseExpr.toExecutionPath(this.mExecutionPath);
        this.mCallbackExprModel.seal();
    }

    public InverseBinding(BindingTarget target, String name, SetterStore.BindingGetterCall getterCall) {
        this.mTarget = target;
        this.mName = name;
        this.mExpr = null;
        this.mCallbackExprModel = null;
        this.mInverseExpr = null;
        this.mVariableExpr = null;
        this.mExecutionPath = null;
        this.setGetterCall(getterCall);
    }

    @Override
    public List<Location> provideScopeLocation() {
        if (this.mExpr != null) {
            return this.mExpr.getLocations();
        }
        return this.mChainedExpressions.get(0).getLocations();
    }

    private void setGetterCall(SetterStore.BindingGetterCall getterCall) {
        this.mGetterCall = getterCall;
    }

    public void addChainedExpression(FieldAccessExpr expr) {
        this.mChainedExpressions.add(expr);
    }

    public boolean isOnBinder() {
        return this.mTarget.getResolvedType().isViewDataBinding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGetterCall(Expr expr) {
        try {
            Scope.enter(this.mTarget);
            Scope.enter(this);
            ModelClass viewType = this.mTarget.getResolvedType();
            SetterStore setterStore = SetterStore.get(ModelAnalyzer.getInstance());
            ModelClass resolvedType = expr == null ? null : expr.getResolvedType();
            this.mGetterCall = setterStore.getGetterCall(this.mName, viewType, resolvedType, expr.getModel().getImports());
            if (this.mGetterCall == null) {
                L.e("Cannot find the getter for attribute '%s' with value type %s on %s.", this.mName, expr == null ? "Unknown" : this.mExpr.getResolvedType(), this.mTarget.getResolvedType());
            }
        }
        finally {
            Scope.exit();
            Scope.exit();
        }
    }

    public SetterStore.BindingGetterCall getGetterCall() {
        return this.mGetterCall;
    }

    public BindingTarget getTarget() {
        return this.mTarget;
    }

    public Expr getExpr() {
        return this.mExpr;
    }

    public Expr getInverseExpr() {
        return this.mInverseExpr;
    }

    public IdentifierExpr getVariableExpr() {
        return this.mVariableExpr;
    }

    public ExecutionPath getExecutionPath() {
        return this.mExecutionPath;
    }

    public CallbackExprModel getCallbackExprModel() {
        return this.mCallbackExprModel;
    }

    public List<FieldAccessExpr> getChainedExpressions() {
        return this.mChainedExpressions;
    }

    public String getBindingAdapterInstanceClass() {
        return this.getGetterCall().getBindingAdapterInstanceClass();
    }

    public int getMinApi() {
        SetterStore.BindingGetterCall getterCall = this.getGetterCall();
        return Math.max(getterCall.getMinApi(), getterCall.getEvent().getMinApi());
    }

    public SetterStore.BindingSetterCall getEventSetter() {
        SetterStore.BindingGetterCall getterCall = this.getGetterCall();
        return getterCall.getEvent();
    }

    public String getName() {
        return this.mName;
    }

    public String getEventAttribute() {
        return this.getGetterCall().getEventAttribute();
    }

    public ExprModel getModel() {
        if (this.mExpr != null) {
            return this.mExpr.getModel();
        }
        return this.mChainedExpressions.get(0).getModel();
    }
}

