/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.model.bootstrap;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.cloud.SpringCloudBundle;
import com.intellij.spring.boot.cloud.library.SpringCloudLibraryUtil;
import com.intellij.spring.boot.cloud.model.bootstrap.SpringBootBootstrapFileSet;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;

public class SpringBootBootstrapConfigurationInspection
extends AbstractBaseUastLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (aClass == null) {
            SpringBootBootstrapConfigurationInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringBootBootstrapConfigurationInspection.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass)) == null) {
            return null;
        }
        PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        if (!SpringCloudLibraryUtil.hasSpringCloudCommons(module) || !SpringCommonUtils.isConfiguration((PsiClass)aClass)) {
            return null;
        }
        SpringBootBootstrapFileSet bootstrapFileSet = SpringBootBootstrapConfigurationInspection.findBootstrapFileSet(springFacet, aClass.getContainingFile().getVirtualFile());
        if (bootstrapFileSet == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        PairProcessor findFirstProcessor = (property, psiClass) -> {
            if (aClass == null) {
                SpringBootBootstrapConfigurationInspection.$$$reportNull$$$0(2);
            }
            return !psiManager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)aClass);
        };
        if (SpringSpiManager.getInstance((Module)module).processClassesListValues(false, aClass.getName(), findFirstProcessor)) {
            return null;
        }
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModelsWithoutDependencies(module);
        for (SpringModel model : models) {
            SpringFileSet fileSet = model.getFileSet();
            if (fileSet == null || !fileSet.getDependencyFileSets().contains((Object)bootstrapFileSet)) continue;
            for (CommonSpringModel commonSpringModel : model.getModelsToProcess()) {
                SpringFileSet modelFileSet;
                if (commonSpringModel instanceof SpringModel && (modelFileSet = ((SpringModel)commonSpringModel).getFileSet()) != null && bootstrapFileSet.getId().equals(modelFileSet.getId())) continue;
                CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
                commonSpringModel.processByClass(SpringModelSearchParameters.byClass((PsiClass)aClass), (Processor)processor);
                if (!processor.isFound()) continue;
                ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
                holder.registerProblem((PsiElement)nameIdentifier, SpringCloudBundle.message("spring.cloud.bootstrap.configuration.component.scanned", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                return holder.getResultsArray();
            }
        }
        return null;
    }

    @Nullable
    private static SpringBootBootstrapFileSet findBootstrapFileSet(SpringFacet springFacet, VirtualFile file) {
        for (SpringFileSet fileSet : SpringFileSetService.getInstance().getModelProviderSets(springFacet)) {
            if (!(fileSet instanceof SpringBootBootstrapFileSet) || !fileSet.hasFile(file)) continue;
            return (SpringBootBootstrapFileSet)fileSet;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/cloud/model/bootstrap/SpringBootBootstrapConfigurationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkClass$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

