/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.internal;

import com.springsource.util.osgi.manifest.internal.HeaderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapUpdatingList
extends ArrayList<String>
implements List<String> {
    private static final long serialVersionUID = 4379585330343695190L;
    private final String key;
    private final Map<String, String> map;

    MapUpdatingList(Map<String, String> map, String key) {
        this.map = map;
        this.key = key;
    }

    @Override
    public boolean add(String string) {
        boolean added = super.add(string);
        this.updateMap();
        return added;
    }

    @Override
    public void add(int index, String string) {
        super.add(index, string);
        this.updateMap();
    }

    @Override
    public boolean addAll(Collection<? extends String> strings) {
        boolean added = super.addAll(strings);
        this.updateMap();
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> strings) {
        boolean added = super.addAll(index, strings);
        this.updateMap();
        return added;
    }

    @Override
    public void clear() {
        super.clear();
        this.updateMap();
    }

    @Override
    public String remove(int index) {
        String removed = (String)super.remove(index);
        this.updateMap();
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = super.remove(o);
        if (removed) {
            this.updateMap();
        }
        return removed;
    }

    private void updateMap() {
        String value = HeaderUtils.toString(this);
        if (value != null) {
            this.map.put(this.key, HeaderUtils.toString(this));
        } else {
            this.map.remove(this.key);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean altered = super.removeAll(c);
        if (altered) {
            this.updateMap();
        }
        return altered;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean altered = super.retainAll(c);
        if (altered) {
            this.updateMap();
        }
        return altered;
    }

    @Override
    public String set(int index, String string) {
        String replaced = super.set(index, string);
        this.updateMap();
        return replaced;
    }
}

