/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.propertysubstitution;

import com.springsource.bundlor.support.TemplateHeaderReader;
import com.springsource.bundlor.support.propertysubstitution.VersionExpander;
import com.springsource.bundlor.support.propertysubstitution.VersionExpansionParser;
import com.springsource.bundlor.util.SimpleParserLogger;
import com.springsource.util.common.PropertyPlaceholderResolver;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParser;
import com.springsource.util.osgi.manifest.parse.HeaderParserFactory;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Version;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VersionExpansionTransformer
implements PropertyPlaceholderResolver.PlaceholderValueTransformer,
TemplateHeaderReader {
    private static final String VERSION_PATTERNS = "Version-Patterns";
    private static final String ATT_PATTERN = "pattern";
    private final Map<String, VersionExpander> expanders = new HashMap<String, VersionExpander>();
    private final Object expandersLock = new Object();

    public VersionExpansionTransformer() {
    }

    public VersionExpansionTransformer(ManifestContents manifestTemplate) {
        String value = manifestTemplate.getMainAttributes().get(VERSION_PATTERNS);
        List<HeaderDeclaration> headers = this.parseTemplate(value);
        for (HeaderDeclaration header : headers) {
            String name = header.getNames().get(0);
            String pattern = header.getAttributes().get(ATT_PATTERN);
            this.expanders.put(name, VersionExpansionParser.parseVersionExpander(pattern));
        }
    }

    @Override
    public String transform(String propertyName, String value, String pattern) {
        Version version = new Version(value);
        VersionExpander expander = this.getVersionExpander(pattern);
        return expander.expand(version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersionExpander getVersionExpander(String pattern) {
        Object object = this.expandersLock;
        synchronized (object) {
            if (!this.expanders.containsKey(pattern)) {
                this.expanders.put(pattern, VersionExpansionParser.parseVersionExpander(pattern));
            }
            return this.expanders.get(pattern);
        }
    }

    @Override
    public List<String> getTemplateOnlyHeaderNames() {
        return Arrays.asList(VERSION_PATTERNS);
    }

    private List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            HeaderParser parser = HeaderParserFactory.newHeaderParser(new SimpleParserLogger());
            return parser.parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }
}

